<?php
/**
 * Plugin Name: v4 DGI
 * Plugin URI: https://visual4.de
 * Description: Anpassungen an Themes/Plugins für DGI
 * Version: 1.0.2
 * Author: visual4 GmbH
 * Author URI: https://visual4.de
 */

add_filter('v4-wp-webhook/register-fields', 'v4_dgi_webhook_register_fields');

if (!function_exists('v4_dgi_webhook_register_fields')) {
    function v4_dgi_webhook_register_fields($register_fields)
    {
        $new_register_fields = [];

        //sort
        foreach ($register_fields as $register_field_key => $register_field) {
            $new_register_fields[$register_field_key] = $register_field;

            //after billing_title
            if ($register_field_key === 'billing_company') {
                $new_register_fields['billing_address_institution'] = [
                    'name' => 'Institution',
                    'validation_type' => 'string',
                    'required' => false,
                    'type' => 'text',
                    'classes' => [
                        'full'
                    ]
                ];
                $new_register_fields['billing_address_department'] = [
                    'name' => 'Abteilung',
                    'validation_type' => 'string',
                    'required' => false,
                    'type' => 'text',
                    'classes' => [
                        'full'
                    ]
                ];
            }
        }

        return $new_register_fields;
    }
}

add_action('show_user_profile', 'v4_dgi_extra_user_profile_fields');
add_action('edit_user_profile', 'v4_dgi_extra_user_profile_fields');

function v4_dgi_extra_user_profile_fields($user)
{
    ?>
    <table class="form-table">
        <tr>
            <th><label for="billing_address_institution"><?php _e("Institution"); ?></label></th>
            <td>
                <input type="text" name="billing_address_institution" id="billing_address_institution"
                       value="<?php echo esc_attr(get_the_author_meta('billing_address_institution', $user->ID)); ?>"
                       class="regular-text"/><br/>
                <span class="description"><?php _e("Please enter your institution."); ?></span>
            </td>
        </tr>
        <tr>
            <th><label for="billing_address_department"><?php _e("Abteilung"); ?></label></th>
            <td>
                <input type="text" name="billing_address_department" id="billing_address_department"
                       value="<?php echo esc_attr(get_the_author_meta('billing_address_department', $user->ID)); ?>"
                       class="regular-text"/><br/>
                <span class="description"><?php _e("Please enter your department."); ?></span>
            </td>
        </tr>
        <tr>
            <th><label for="shipping_address_institution"><?php _e("Institution"); ?></label></th>
            <td>
                <input type="text" name="shipping_address_institution" id="shipping_address_institution"
                       value="<?php echo esc_attr(get_the_author_meta('shipping_address_institution', $user->ID)); ?>"
                       class="regular-text"/><br/>
                <span class="description"><?php _e("Please enter your institution."); ?></span>
            </td>
        </tr>
        <tr>
            <th><label for="shipping_address_department"><?php _e("Abteilung"); ?></label></th>
            <td>
                <input type="text" name="shipping_address_department" id="shipping_address_department"
                       value="<?php echo esc_attr(get_the_author_meta('shipping_address_department', $user->ID)); ?>"
                       class="regular-text"/><br/>
                <span class="description"><?php _e("Please enter your department."); ?></span>
            </td>
        </tr>
    </table>
    <?php
}

add_action('personal_options_update', 'v4_dgi_save_extra_user_profile_fields');
add_action('edit_user_profile_update', 'v4_dgi_save_extra_user_profile_fields');

function v4_dgi_save_extra_user_profile_fields($user_id)
{
    if (empty($_POST['_wpnonce']) || !wp_verify_nonce($_POST['_wpnonce'], 'update-user_' . $user_id)) {
        return false;
    }

    if (!current_user_can('edit_user', $user_id)) {
        return false;
    }
    update_user_meta($user_id, 'billing_address_institution', $_POST['billing_address_institution']);
    update_user_meta($user_id, 'billing_address_department', $_POST['billing_address_department']);
    update_user_meta($user_id, 'shipping_address_institution', $_POST['shipping_address_institution']);
    update_user_meta($user_id, 'shipping_address_department', $_POST['shipping_address_department']);

    return true;
}

add_filter('woocommerce_checkout_fields', 'v4_dgi_wc_checkout_fields');

if (!function_exists('v4_dgi_wc_checkout_fields')) {
    function v4_dgi_wc_checkout_fields($fields)
    {
        $fields['billing']['billing_address_institution'] = array(
            'label' => 'Institution',
            'class' =>
                array(
                    0 => 'form-row-first',
                ),
            'priority' => 30,
            'type' => 'text',
            'required' => false,
        );
        $fields['billing']['billing_address_department'] = array(
            'label' => 'Abteilung',
            'class' =>
                array(
                    0 => 'form-row-last',
                ),
            'priority' => 30,
            'type' => 'text',
            'required' => false,
        );
        $fields['shipping']['shipping_address_institution'] = array(
            'label' => 'Institution',
            'class' =>
                array(
                    0 => 'form-row-first',
                ),
            'priority' => 30,
            'type' => 'text',
            'required' => false,
        );
        $fields['shipping']['shipping_address_department'] = array(
            'label' => 'Abteilung',
            'class' =>
                array(
                    0 => 'form-row-last',
                ),
            'priority' => 30,
            'type' => 'text',
            'required' => false,
        );
        if (is_user_logged_in() && is_checkout()) {
            $fields['billing']['billing_address_institution']['custom_attributes']['v4readonly'] = 'readonly';
            $fields['billing']['billing_address_department']['custom_attributes']['v4readonly'] = 'readonly';
        }

        return $fields;
    }
}

add_action('woocommerce_checkout_update_customer', 'v4_dgi_save_posted_title_in_customer', 10, 2);
function v4_dgi_save_posted_title_in_customer($customer, $data)
{
    if (isset($data['billing_address_institution']))
        $customer->update_meta_data('billing_address_institution', $data['billing_address_institution']);
    if (isset($data['billing_address_department']))
        $customer->update_meta_data('billing_address_department', $data['billing_address_department']);
    if (isset($data['shipping_address_institution']))
        $customer->update_meta_data('shipping_address_institution', $data['shipping_address_institution']);
    if (isset($data['shipping_address_department']))
        $customer->update_meta_data('shipping_address_department', $data['shipping_address_department']);
}

add_filter('woocommerce_billing_fields', 'v4_dgi_wc_edit_billing_fields', 55, 2);
function v4_dgi_wc_edit_billing_fields($address_fields, $country)
{
    if (is_user_logged_in() && is_checkout()) {
        $address_fields['billing_alt_institution'] = array(
            'label' => 'abw. Institution für Rechnungsstellung',
            'class' => array('form-row-first'),
            'priority' => 121
        );
        $address_fields['billing_alt_department'] = array(
            'label' => 'abw. Abteilung für Rechnungsstellung',
            'class' => array('form-row-last'),
            'priority' => 122
        );
    }
    return $address_fields;
}

add_filter('woocommerce_shipping_fields', 'v4_dgi_wc_edit_shipping_fields', 55, 2);
function v4_dgi_wc_edit_shipping_fields($address_fields, $country)
{
    $address_fields['shipping_address_institution'] = array(
        'label' => __('abw. Institution für Lieferung', 'v4-dginet'),
        'class' => array('form-row-first'),
        'priority' => 30
    );
    $address_fields['shipping_address_department'] = array(
        'label' => __('abw. Abteilung für Lieferung', 'v4-dginet'),
        'class' => array('form-row-last'),
        'priority' => 30
    );
    return $address_fields;
}
