<?php

namespace v4\wp\plugins\wp1crm;

if (!defined('ABSPATH')) die;

class AltAddress
{
	public function __construct()
	{
        $v4_wpwh = get_option('v4_wpwh');
        if (empty($v4_wpwh['alt_address']) || $v4_wpwh['alt_address'] === 'no')
            return;

		add_action('plugins_loaded', [$this, 'load_plugin_textdomain']);
		add_filter('woocommerce_billing_fields', [$this, 'wc_edit_billing_fields'], 50, 2);
		add_filter('woocommerce_order_formatted_billing_address', [$this, 'woocommerce_order_formatted_billing_address'], 20, 2);
		add_filter('woocommerce_order_get_billing_email', [$this, 'woocommerce_order_get_billing_email'], 20, 2);
		add_filter('woocommerce_order_get_billing_phone', [$this, 'woocommerce_order_get_billing_phone'], 20, 2);
		add_filter('init', [$this, 'em_remove_captcha'], 20, 0);
		add_filter('woocommerce_form_field', [$this, 'woocommerce_form_field'], 20, 4);
		add_filter('em_locate_template', [$this, 'relocate_em_templates'], 40, 4);
		add_filter('woocommerce_form_field_info', [$this, 'woocommerce_form_field_info'], 20, 4);
	}

	public function woocommerce_form_field_info($field, $key, $args, $value){
		return "<p>{$args['label']}</p>";
	}

	public function woocommerce_form_field($field, $key, $args, $value)
	{
		if(isset($args['custom_attributes']['v4readonly'])){

			//bugfix empty fields on reload checkout page
			if (empty($value) && isset($args['required']) && $args['required']){
				$value = get_user_meta(get_current_user_id(), $args['id'], true);
			}

			if ($args['type'] === 'select' || $args['type'] === 'country') {
				$value_html = $args['options'][$value] ?: '-';
			} else {
				$value_html = $value ?: '-';
			}

			//display if missing required fields
			if ($value_html === '-' && isset($args['required']) && $args['required'])
				return $field;

			ob_start();
			?>
			<p class="form-row <?= implode(' ', $args['class']) ?>" id="<?= $args['id'] ?>" data-priority="">
				<input type="hidden" name="<?= $args['id'] ?>" id="<?= $args['id'] ?>" value="<?= $value ?>">
				<label><?= $args['label'] ?></label>
				<span class="woocommerce-input-wrapper"><b><?= $value_html ?></b></span>
			</p>
			<?php
			$field = ob_get_clean();
		}

		return $field;
	}

	public function load_plugin_textdomain()
	{
		
	}

	public function wc_edit_billing_fields($address_fields, $country)
	{
		$address_fields['billing_email']['priority'] = 25;
		if (is_user_logged_in() && is_checkout()) {
			$address_fields['billing_first_name']['custom_attributes']['v4readonly'] = 'readonly';
			$address_fields['billing_last_name']['custom_attributes']['v4readonly'] = 'readonly';
			$address_fields['billing_email']['custom_attributes']['v4readonly'] = 'readonly';
			$address_fields['billing_company']['custom_attributes']['v4readonly'] = 'readonly';
			$address_fields['billing_address_1']['custom_attributes']['v4readonly'] = 'readonly';
			$address_fields['billing_address_2']['custom_attributes']['v4readonly'] = 'readonly';
			$address_fields['billing_postcode']['custom_attributes']['v4readonly'] = 'readonly';
			$address_fields['billing_city']['custom_attributes']['v4readonly'] = 'readonly';
			$address_fields['billing_phone']['custom_attributes']['v4readonly'] = 'readonly';
			$address_fields['billing_title']['custom_attributes']['v4readonly'] = 'readonly';
			$address_fields['billing_country']['custom_attributes']['v4readonly'] = 'readonly';

			$address_fields['billing_country']['type'] = 'select';
			$address_fields['billing_country']['options'] = WC()->countries->get_countries();

			$address_fields['billing_postcode']['class'] = array('form-row-first');
			$address_fields['billing_city']['class'] = array('form-row-last');

			$address_fields['billing_title']['priority'] = 1;

			/*
			 * new fields
			 */

//			$address_fields['billing_info'] = array(
//				'type' => 'info',
//				'label' => __('We have the following data for invoicing (they correspond to the data from your account registration):', 'v4-wp-webhook'),
//				'priority' => 0
//			);
			$address_fields['billing_alt_info'] = array(
				'type' => 'info',
				'label' => __('In the following, if desired, you can provide us with different data for invoicing:', 'v4-wp-webhook'),
				'priority' => 100
			);

            $address_fields['billing_alt_name'] = array(
                'label' => __('Alternative name', 'v4-wp-webhook'),
                'class' => array('form-row-wide'),
                'priority' => 110
            );
			$address_fields['billing_alt_company'] = array(
				'label' => __('Alternative company name', 'v4-wp-webhook'),
				'class' => array('form-row-wide'),
				'priority' => 120
			);
			$address_fields['billing_alt_address'] = array(
				'label' => __('Alternative address', 'v4-wp-webhook'),
                'type' => 'textarea',
				'class' => array('form-row-wide'),
				'priority' => 130
			);
			$address_fields['billing_alt_postcode'] = array(
				'label' => __('Alternative postcode', 'v4-wp-webhook'),
				'class' => array('form-row-first'),
				'priority' => 140
			);
			$address_fields['billing_alt_city'] = array(
				'label' => __('Alternative city', 'v4-wp-webhook'),
				'class' => array('form-row-last'),
				'priority' => 150
			);
            $address_fields['billing_alt_country'] = array(
                'label' => __('Alternative country', 'v4-wp-webhook'),
                'class' => array('form-row-wide'),
                'type' => 'country',
                'priority' => 160
            );
		}

		return $address_fields;
	}

	public function woocommerce_order_get_billing_email($email, \WC_Order $WC_Order)
	{
		foreach ($WC_Order->get_meta_data() as $meta_datum) {
			$data = $meta_datum->get_data();
			switch ($data['key']) {
				case 'billing_alt_email':
				case '_billing_alt_email':
					$email = $data['value'];
					break;
			}
		}
		return $email;
	}

	public function woocommerce_order_get_billing_phone($email, \WC_Order $WC_Order)
	{
		foreach ($WC_Order->get_meta_data() as $meta_datum) {
			$data = $meta_datum->get_data();
			switch ($data['key']) {
				case 'billing_alt_phone':
				case '_billing_alt_phone':
					$email = $data['value'];
					break;
			}
		}
		return $email;
	}

	public function woocommerce_order_formatted_billing_address($address, \WC_Order $WC_Order)
	{
		$is_alt_address = false;
		foreach ($WC_Order->get_meta_data() as $meta_datum) {
			$data = $meta_datum->get_data();
			if(
				(
					$data['key'] == 'billing_alt_title' ||
					$data['key'] == 'billing_alt_first_name' ||
					$data['key'] == 'billing_alt_last_name' ||
					$data['key'] == 'billing_alt_name' ||
					$data['key'] == 'billing_alt_email' ||
					$data['key'] == 'billing_alt_company' ||
					$data['key'] == 'billing_alt_country' ||
					$data['key'] == 'billing_alt_address' ||
					$data['key'] == 'billing_alt_postcode' ||
					$data['key'] == 'billing_alt_city' ||
					$data['key'] == 'billing_alt_phone' ||
					$data['key'] == '_billing_alt_title' ||
					$data['key'] == '_billing_alt_first_name' ||
					$data['key'] == '_billing_alt_last_name' ||
					$data['key'] == '_billing_alt_name' ||
					$data['key'] == '_billing_alt_email' ||
					$data['key'] == '_billing_alt_company'||
					$data['key'] == '_billing_alt_country'||
					$data['key'] == '_billing_alt_address'||
					$data['key'] == '_billing_alt_postcode'||
					$data['key'] == '_billing_alt_city'||
					$data['key'] == '_billing_alt_phone'
				) &&
				!empty($data['value'])
			){
				$is_alt_address = true;
			}
		}
		if($is_alt_address){
			foreach ($WC_Order->get_meta_data() as $meta_datum) {
				$data = $meta_datum->get_data();
				switch ($data['key']){
					case 'billing_alt_title':
					case '_billing_alt_title':
						$address['title'] = $data['value'];
						break;
					case 'billing_alt_first_name':
					case '_billing_alt_first_name':
						$address['first_name'] = $data['value'];
						break;
					case 'billing_alt_last_name':
					case '_billing_alt_last_name':
						$address['last_name'] = $data['value'];
						break;
					case 'billing_alt_name':
					case '_billing_alt_name':
						$address['name'] = $data['value'];
						break;
					case 'billing_alt_email':
					case '_billing_alt_email':
						$address['email'] = $data['value'];
						break;
					case 'billing_alt_company':
					case '_billing_alt_company':
						$address['company'] = $data['value'];
						break;
					case 'billing_alt_country':
					case '_billing_alt_country':
						$address['country'] = $data['value'];
						break;
					case 'billing_alt_address':
					case '_billing_alt_address':
						$address['address_1'] = $data['value'];
						break;
					case 'billing_alt_postcode':
					case '_billing_alt_postcode':
						$address['postcode'] = $data['value'];
						break;
					case 'billing_alt_city':
					case '_billing_alt_city':
						$address['city'] = $data['value'];
						break;
					case 'billing_alt_phone':
					case '_billing_alt_phone':
						$address['phone'] = $data['value'];
						break;
				}
			}
		}
		return $address;
	}

	public function em_remove_captcha(){
		global $V4_Wp_Webhook_Admin;
		remove_action('booking_form_after_user_details', [$V4_Wp_Webhook_Admin , 'template_recaptcha'], 5);
		remove_action('em_checkout_form_footer', [$V4_Wp_Webhook_Admin, 'template_recaptcha'], 5);
		remove_action('em_booking_form_footer', [$V4_Wp_Webhook_Admin, 'template_recaptcha'], 5);
	}

	public function relocate_em_templates($located, $template_name, $load, $the_args)
	{
		if ($template_name == 'forms/bookingform/login.php') {
			$located = __DIR__ . '/em/forms/bookingform/login.php';
		}

		return $located;
	}

}

return new AltAddress();