<?php

namespace v4\wp\plugins\wp1crm;

use EM_Booking_Form;
use Exception;
use v4Webhook;
use WC_Customer;
use EM_Person;
use WC_Meta_Data;
use WP_User;

if (!defined('ABSPATH'))
	die('wrong entry point');


class Customer
{
	public WC_Customer $WC_Customer;
	public EM_Person $EM_Person;
	public WP_User $WP_User;

	/**
	 * @var array $data
	 */
	protected array $data = [
		"id" => 0,
		"crm_id" => "",
		"case" => "",
		"guest" => false,
		"email" => "",
		"last_name" => "",
		"role" => "subscriber",
		"billing" => [
			"last_name" => "",
		],
		"meta_data" => []
	];

	/**
	 * @var array|string[] $meta_db_keys
	 */
	protected array $meta_db_keys = [
		'crm_id',
		'billing_first_name',
		'billing_last_name',
		'billing_company',
		'billing_address_1',
		'billing_address_2',
		'billing_city',
		'billing_state',
		'billing_postcode',
		'billing_country',
		'billing_email',
		'billing_phone',
		'billing_title',
		'shipping_first_name',
		'shipping_last_name',
		'shipping_company',
		'shipping_address_1',
		'shipping_address_2',
		'shipping_city',
		'shipping_state',
		'shipping_postcode',
		'shipping_country',
		'shipping_title',
		'shipping_phone',
	];

	protected array $em_db_mapping = [
		'billing_company' => 'dbem_company',
		'billing_address_1' => 'dbem_address',
		'billing_city' => 'dbem_city',
		'billing_state' => 'dbem_state',
		'billing_postcode' => 'dbem_zip',
		'billing_country' => 'dbem_country',
		'billing_phone' => 'dbem_phone',
		'billing_title' => 'dbem_salutation',
	];

	protected array $errors = [];

	/**
	 * @param mixed $data
	 * @throws Exception
	 */
	public function __construct($data)
	{
        global $V4_Wp_Webhook_Admin;
        $role = $V4_Wp_Webhook_Admin->get_default_role();
        $this->set_roles($role);

		if (is_int($data)) {

			$this->init_from_db($data);

		} else {
			if (is_array($data)) {

				$this->set_data($data);

			} elseif (is_object($data) && get_class($data) == 'EM_Person') {

				$this->set_em_data($data);

			} elseif (is_object($data) && get_class($data) == 'WC_Customer') {

				$this->set_wc_data($data);

			}
		}

		do_action('v4/wp/plugins/wp1crm/customer_init', $this);
	}

	/**
	 * @param $id
	 * @return bool
	 */
	protected function init_from_db($id): bool
	{
		$WP_User = get_userdata($id);
		if (is_a($WP_User, 'WP_User')) {
			$this->WP_User = $WP_User;
			$this->set_id($id);
			$this->set_email($WP_User->user_email);
			$this->set_first_name($WP_User->first_name);
			$this->set_last_name($WP_User->last_name);
			$this->set_roles($WP_User->roles);
			$this->add_meta_data_from_db();
			return true;
		}
		return false;
	}

	public function add_meta_data_from_db(): bool
	{
		if (empty($this->data['id']))
			return false;

		$user_meta = get_user_meta($this->data['id']);
		foreach ($user_meta as $meta_key => $meta_value) {
			$meta_value = self::maybe_unserialize($meta_value);
			if (is_array($meta_value) && count($meta_value) == 1 && isset($meta_value[0]))
				$meta_value = $meta_value[0];
			if (in_array($meta_key, $this->meta_db_keys)) {
				$set_function = "set_$meta_key";
				if (method_exists($this, $set_function))
					$this->$set_function($meta_value);
			} else {
				$this->add_meta_data($meta_key, $meta_value);
			}
		}

		return true;
	}

	protected function set_data(array $data)
	{
		$id = $data['id'] ?? null;
		$email = $data['email'] ?? null;
		$first_name = $data['first_name'] ?? $data['billing']['first_name'] ?? $data['billing_first_name'] ?? null;
		$last_name = $data['last_name'] ?? $data['billing']['last_name'] ?? $data['billing_last_name'] ?? null;
		$roles = $data['roles'] ?? null;

		$billing_first_name = $data['billing']['first_name'] ?? $data['billing_first_name'] ?? $first_name;
		$billing_last_name = $data['billing']['last_name'] ?? $data['billing_last_name'] ?? $last_name;
		$billing_email = $data['billing']['email'] ?? $data['billing_email'] ?? $email;
		$billing_company = $data['billing']['company'] ?? $data['billing_company'] ?? null;
		$billing_address_1 = $data['billing']['address_1'] ?? $data['billing_address_1'] ?? null;
		$billing_address_2 = $data['billing']['address_2'] ?? $data['billing_address_2'] ?? null;
		$billing_city = $data['billing']['city'] ?? $data['billing_city'] ?? null;
		$billing_state = $data['billing']['state'] ?? $data['billing_state'] ?? null;
		$billing_postcode = $data['billing']['postcode'] ?? $data['billing_postcode'] ?? null;
		$billing_country = $data['billing']['country'] ?? $data['billing_country'] ?? null;
		$billing_phone = $data['billing']['phone'] ?? $data['billing_phone'] ?? null;
		$billing_title = $data['billing']['title'] ?? $data['billing_title'] ?? null;

		$shipping_first_name = $data['shipping']['first_name'] ?? $data['shipping_first_name'] ?? null;
		$shipping_last_name = $data['shipping']['last_name'] ?? $data['shipping_last_name'] ?? null;
		$shipping_company = $data['shipping']['company'] ?? $data['shipping_company'] ?? null;
		$shipping_address_1 = $data['shipping']['address_1'] ?? $data['shipping_address_1'] ?? null;
		$shipping_address_2 = $data['shipping']['address_2'] ?? $data['shipping_address_2'] ?? null;
		$shipping_city = $data['shipping']['city'] ?? $data['shipping_city'] ?? null;
		$shipping_state = $data['shipping']['state'] ?? $data['shipping_state'] ?? null;
		$shipping_postcode = $data['shipping']['postcode'] ?? $data['shipping_postcode'] ?? null;
		$shipping_country = $data['shipping']['country'] ?? $data['shipping_country'] ?? null;
		$shipping_phone = $data['shipping']['phone'] ?? $data['shipping_phone'] ?? null;
		$shipping_title = $data['shipping']['title'] ?? $data['shipping_title'] ?? null;

		unset(
			$data['id'],
			$data['email'],
			$data['first_name'],
			$data['last_name'],
			$data['roles'],
			$data['billing']['first_name'],
			$data['billing_first_name'],
			$data['billing']['last_name'],
			$data['billing_last_name'],
			$data['billing']['email'],
			$data['billing_email'],
			$data['billing']['company'],
			$data['billing_company'],
			$data['billing']['address_1'],
			$data['billing_address_1'],
			$data['billing']['address_2'],
			$data['billing_address_2'],
			$data['billing']['city'],
			$data['billing_city'],
			$data['billing']['state'],
			$data['billing_state'],
			$data['billing']['postcode'],
			$data['billing_postcode'],
			$data['billing']['country'],
			$data['billing_country'],
			$data['billing']['phone'],
			$data['billing_phone'],
			$data['billing']['title'],
			$data['billing_title'],
			$data['shipping']['first_name'],
			$data['shipping_first_name'],
			$data['shipping']['last_name'],
			$data['shipping_last_name'],
			$data['shipping']['company'],
			$data['shipping_company'],
			$data['shipping']['address_1'],
			$data['shipping_address_1'],
			$data['shipping']['address_2'],
			$data['shipping_address_2'],
			$data['shipping']['city'],
			$data['shipping_city'],
			$data['shipping']['state'],
			$data['shipping_state'],
			$data['shipping']['postcode'],
			$data['shipping_postcode'],
			$data['shipping']['country'],
			$data['shipping_country'],
			$data['shipping']['phone'],
			$data['shipping_phone'],
			$data['shipping']['title'],
			$data['shipping_title']
		);

		if ($id !== null) $this->set_id($id);
		if ($email !== null) $this->set_email($email);
		if ($first_name !== null) $this->set_first_name($first_name);
		if ($last_name !== null) $this->set_last_name($last_name);
		if ($roles !== null) $this->set_roles($roles);
		//billing
		if ($billing_first_name !== null) $this->set_billing_first_name($billing_first_name);
		if ($billing_last_name !== null) $this->set_billing_last_name($billing_last_name);
		if ($billing_company !== null) $this->set_billing_company($billing_company);
		if ($billing_address_1 !== null) $this->set_billing_address_1($billing_address_1);
		if ($billing_address_2 !== null) $this->set_billing_address_2($billing_address_2);
		if ($billing_city !== null) $this->set_billing_city($billing_city);
		if ($billing_state !== null) $this->set_billing_state($billing_state);
		if ($billing_postcode !== null) $this->set_billing_postcode($billing_postcode);
		if ($billing_country !== null) $this->set_billing_country($billing_country);
		if ($billing_email !== null) $this->set_billing_email($billing_email);
		if ($billing_phone !== null) $this->set_billing_phone($billing_phone);
		if ($billing_title !== null) $this->set_billing_title($billing_title);
		//shipping
		if ($shipping_first_name !== null) $this->set_shipping_first_name($shipping_first_name);
		if ($shipping_last_name !== null) $this->set_shipping_last_name($shipping_last_name);
		if ($shipping_company !== null) $this->set_shipping_company($shipping_company);
		if ($shipping_address_1 !== null) $this->set_shipping_address_1($shipping_address_1);
		if ($shipping_address_2 !== null) $this->set_shipping_address_2($shipping_address_2);
		if ($shipping_city !== null) $this->set_shipping_city($shipping_city);
		if ($shipping_state !== null) $this->set_shipping_state($shipping_state);
		if ($shipping_postcode !== null) $this->set_shipping_postcode($shipping_postcode);
		if ($shipping_country !== null) $this->set_shipping_country($shipping_country);
		if ($shipping_phone !== null) $this->set_shipping_phone($shipping_phone);
		if ($shipping_title !== null) $this->set_shipping_title($shipping_title);
		//meta data
		if (!empty($data['meta_data'])) {
			$this->set_meta_data($data['meta_data']);
		}
		unset($data['meta_data']);
		//try to add rest data to meta
		foreach ($data as $key => $value) {
			$this->add_meta_data($key, $value);
		}
	}

	/**
	 * @throws Exception
	 */
	protected function set_em_data(EM_Person $data)
	{
		$this->EM_Person = $data;

		$WP_User = get_userdata($data->ID);
		if (is_a($WP_User, 'WP_User')) {
			if ($WP_User->user_email !== $data->user_email)
				throw new Exception('email change is not allowed', 400);
			$this->WP_User = $WP_User;
			$this->set_id($this->WP_User->ID);
			$this->set_crm_id(get_user_meta($this->WP_User, 'crm_id', true));
		}

		//todo name out of dbem_name

		if (empty($data->custom_user_fields) && class_exists('EM_Booking_Form')) {
			$EM_Form = EM_Booking_Form::get_form();
			if ($EM_Form->get_post() && $EM_Form->validate()) { //get post and validate at once
				foreach ($EM_Form->form_fields as $field_id => $field) {
					if(isset($EM_Form->field_values[$field_id]))
						$data->custom_user_fields[$field_id] = $EM_Form->field_values[$field_id];
				}
			}
		}

		//name
		if (isset($data->custom_user_fields['first_name']))
			$em_cstm_first_name =
				is_array($data->custom_user_fields['first_name']) ?
					$data->custom_user_fields['first_name']['value'] :
					$data->custom_user_fields['first_name'];
		if (isset($data->custom_user_fields['dbem_first_name']))
			$em_cstm_dbem_first_name =
				is_array($data->custom_user_fields['dbem_first_name']) ?
					$data->custom_user_fields['dbem_first_name']['value'] :
					$data->custom_user_fields['dbem_first_name'];
		if (isset($data->custom_user_fields['last_name']))
			$em_cstm_last_name =
				is_array($data->custom_user_fields['last_name']) ?
					$data->custom_user_fields['last_name']['value'] :
					$data->custom_user_fields['last_name'];
		if (isset($data->custom_user_fields['dbem_last_name']))
			$em_cstm_dbem_last_name =
				is_array($data->custom_user_fields['dbem_last_name']) ?
					$data->custom_user_fields['dbem_last_name']['value'] :
					$data->custom_user_fields['dbem_last_name'];
		if (isset($data->custom_user_fields['name']))
			$em_cstm_name =
				is_array($data->custom_user_fields['name']) ?
					$data->custom_user_fields['name']['value'] :
					$data->custom_user_fields['name'];
		if (isset($data->custom_user_fields['dbem_name']))
			$em_cstm_dbem_name =
				is_array($data->custom_user_fields['dbem_name']) ?
					$data->custom_user_fields['dbem_name']['value'] :
					$data->custom_user_fields['dbem_name'];
		$first_name =
			$em_cstm_first_name ??
			$em_cstm_dbem_first_name ??
			$data->first_name;
		$last_name =
			$em_cstm_last_name ??
			$em_cstm_dbem_last_name ??
			$data->last_name;
		if (empty($last_name)) {
			$name =
				$em_cstm_name ??
				$em_cstm_dbem_name ??
				$data->user_name ??
				$data->display_name;
			$name_arr = explode(' ', $name);
			if (count($name_arr) > 1) {
				$first_name = $name_arr[0];
				unset($name_arr[0]);
			}
			$last_name = implode(' ', $name_arr);
		}

		$this->set_email($data->user_email);
		$this->set_first_name($first_name);
		$this->set_last_name($last_name);
		$this->set_roles($data->roles);
		//billing
		$this->set_billing_first_name($first_name);
		$this->set_billing_last_name($last_name);
		$this->set_billing_email($data->user_email);
		if (isset($data->custom_user_fields['dbem_company']))
			$this->set_billing_company(is_array($data->custom_user_fields['dbem_company']) ? $data->custom_user_fields['dbem_company']['value'] : $data->custom_user_fields['dbem_company']);
		if (isset($data->custom_user_fields['dbem_address']))
			$this->set_billing_address_1(is_array($data->custom_user_fields['dbem_address']) ? $data->custom_user_fields['dbem_address']['value'] : $data->custom_user_fields['dbem_address']);
		if (isset($data->custom_user_fields['dbem_address_2']))
			$this->set_billing_address_2(is_array($data->custom_user_fields['dbem_address_2']) ? $data->custom_user_fields['dbem_address_2']['value'] : $data->custom_user_fields['dbem_address_2']);
		if (isset($data->custom_user_fields['dbem_city']))
			$this->set_billing_city(is_array($data->custom_user_fields['dbem_city']) ? $data->custom_user_fields['dbem_city']['value'] : $data->custom_user_fields['dbem_city']);
		if (isset($data->custom_user_fields['dbem_state']))
			$this->set_billing_state(is_array($data->custom_user_fields['dbem_state']) ? $data->custom_user_fields['dbem_state']['value'] : $data->custom_user_fields['dbem_state']);
		if (isset($data->custom_user_fields['dbem_zip']))
			$this->set_billing_postcode(is_array($data->custom_user_fields['dbem_zip']) ? $data->custom_user_fields['dbem_zip']['value'] : $data->custom_user_fields['dbem_zip']);
		if (isset($data->custom_user_fields['dbem_country']))
			$this->set_billing_country(is_array($data->custom_user_fields['dbem_country']) ? $data->custom_user_fields['dbem_country']['value'] : $data->custom_user_fields['dbem_country']);
		if (isset($data->custom_user_fields['dbem_phone']))
			$this->set_billing_phone(is_array($data->custom_user_fields['dbem_phone']) ? $data->custom_user_fields['dbem_phone']['value'] : $data->custom_user_fields['dbem_phone']);
		if (isset($data->custom_user_fields['dbem_salutation']))
			$this->set_billing_title(is_array($data->custom_user_fields['dbem_salutation']) ? $data->custom_user_fields['dbem_salutation']['value'] : $data->custom_user_fields['dbem_salutation']);

		// meta_data
		foreach ($data->custom_user_fields as $custom_user_field_key => $custom_user_field_value) {
			if (!in_array($custom_user_field_key, $this->em_db_mapping)) {
				$prefix = 'dbem_';
				$meta_key = $custom_user_field_key;
				if (substr($meta_key, 0, strlen($prefix)) == $prefix) {
					$meta_key = substr($meta_key, strlen($prefix));
				}
				$this->add_meta_data($meta_key, is_array($custom_user_field_value) ? $custom_user_field_value['value'] : $custom_user_field_value);
			}
		}
		$this->add_meta_data_from_db();
	}

	/**
	 * @throws Exception
	 */
	protected function set_wc_data(WC_Customer $data)
	{
		$this->WC_Customer = $data;

		$WP_User = get_userdata($data->get_id());
		if (is_a($WP_User, 'WP_User')) {
			if ($WP_User->user_email !== $data->get_email())
				throw new Exception('email change is not allowed', 400);
			$this->WP_User = $WP_User;
			$roles = $WP_User->roles;
			$this->set_id($this->WP_User->ID);
			$this->set_crm_id(get_user_meta($this->WP_User, 'crm_id', true));
		} else {
			$roles = [$data->get_role()];
		}

		$this->set_email($data->get_email());
		$this->set_first_name($data->get_first_name());
		$this->set_last_name($data->get_last_name());
		$this->set_roles($roles);
		//billing
		$this->set_billing_first_name($data->get_billing_first_name());
		$this->set_billing_last_name($data->get_billing_last_name());
		$this->set_billing_company($data->get_billing_company());
		$this->set_billing_address_1($data->get_billing_address_1());
		$this->set_billing_address_2($data->get_billing_address_2());
		$this->set_billing_city($data->get_billing_city());
		$this->set_billing_state($data->get_billing_state());
		$this->set_billing_postcode($data->get_billing_postcode());
		$this->set_billing_country($data->get_billing_country());
		$this->set_billing_email($data->get_billing_email());
		$this->set_billing_phone($data->get_billing_phone());
		//shipping
		if ($data->has_shipping_address()) {
			$this->set_shipping_first_name($data->get_shipping_first_name());
			$this->set_shipping_last_name($data->get_shipping_last_name());
			$this->set_shipping_company($data->get_shipping_company());
			$this->set_shipping_address_1($data->get_shipping_address_1());
			$this->set_shipping_address_2($data->get_shipping_address_2());
			$this->set_shipping_city($data->get_shipping_city());
			$this->set_shipping_state($data->get_shipping_state());
			$this->set_shipping_postcode($data->get_shipping_postcode());
			$this->set_shipping_country($data->get_shipping_country());
			$this->set_shipping_phone($data->get_shipping_phone());
		}
		$meta_data = $data->get_meta_data();
		if (!empty($meta_data)) {
			if (is_a($meta_data[0], 'WC_Meta_Data')) {
				/** @var WC_Meta_Data $meta_datum */
				foreach ($meta_data as $meta_datum) {
					$this->add_meta_data($meta_datum->get_data()['key'], $meta_datum->get_data()['value']);
				}
			} else {
				$this->set_meta_data($meta_data);
			}
		}
		$this->add_meta_data_from_db();
	}


	/*
	 * has
	 */
	public function has_shipping_address(): bool
	{
		return isset($this->data['shipping']);
	}


	/*
	 * getter
	 */

	public function get_data(): array
	{
		return $this->data;
	}

	public function get_id()
	{
		return $this->data['id'];
	}

	public function get_crm_id()
	{
		return $this->data['crm_id'];
	}

	public function get_email()
	{
		return $this->data['email'];
	}

	public function get_first_name()
	{
		return $this->data['first_name'] ?? '';
	}

	public function get_last_name()
	{
		return $this->data['last_name'] ?? '';
	}

	public function get_role()
	{
		return $this->data['role'];
	}

	public function get_roles(): array
	{
		return array_merge([$this->get_role()], $this->get_additional_roles());
	}

	public function get_additional_roles()
	{
		return $this->data['additional_roles'] ?? [];
	}

	public function get_billing_first_name()
	{
		return $this->data['billing']['first_name'] ?? '';
	}

	public function get_billing_last_name()
	{
		return $this->data['billing']['last_name'] ?? '';
	}

	public function get_billing_company()
	{
		return $this->data['billing']['company'] ?? '';
	}

	public function get_billing_address_1()
	{
		return $this->data['billing']['address_1'] ?? '';
	}

	public function get_billing_address_2()
	{
		return $this->data['billing']['address_2'] ?? '';
	}

	public function get_billing_city()
	{
		return $this->data['billing']['city'] ?? '';
	}

	public function get_billing_state()
	{
		return $this->data['billing']['state'] ?? '';
	}

	public function get_billing_postcode()
	{
		return $this->data['billing']['postcode'] ?? '';
	}

	public function get_billing_country()
	{
		return $this->data['billing']['country'] ?? '';
	}

	public function get_billing_email()
	{
		return $this->data['billing']['email'] ?? '';
	}

	public function get_billing_phone()
	{
		return $this->data['billing']['phone'] ?? '';
	}

	public function get_billing_title()
	{
		return $this->data['billing']['title'] ?? '';
	}

	public function get_shipping_first_name()
	{
		return $this->data['shipping']['first_name'] ?? '';
	}

	public function get_shipping_last_name()
	{
		return $this->data['shipping']['last_name'] ?? '';
	}

	public function get_shipping_company()
	{
		return $this->data['shipping']['company'] ?? '';
	}

	public function get_shipping_address_1()
	{
		return $this->data['shipping']['address_1'] ?? '';
	}

	public function get_shipping_address_2()
	{
		return $this->data['shipping']['address_2'] ?? '';
	}

	public function get_shipping_city()
	{
		return $this->data['shipping']['city'] ?? '';
	}

	public function get_shipping_state()
	{
		return $this->data['shipping']['state'] ?? '';
	}

	public function get_shipping_postcode()
	{
		return $this->data['shipping']['postcode'] ?? '';
	}

	public function get_shipping_country()
	{
		return $this->data['shipping']['country'] ?? '';
	}

	public function get_shipping_phone()
	{
		return $this->data['shipping']['phone'] ?? '';
	}

	public function get_shipping_title()
	{
		return $this->data['shipping']['title'] ?? '';
	}

	public function get_errors(): array
	{
		return $this->errors;
	}

	/*
	 * cases
	 */

	public function set_case_only_on_match()
	{
		$this->data['case'] = 'only_on_match';
	}

	/*
	 * setter
	 */

	public function set_id($value)
	{
		$this->data['id'] = $value;
	}

	public function set_crm_id($value)
	{
		$this->data['crm_id'] = $value;
	}

	public function set_email($value)
	{
		$this->data['email'] = $value;
	}

	public function set_first_name($value)
	{
		$this->data['first_name'] = $value;
	}

	public function set_last_name($value)
	{
		$this->data['last_name'] = $value;
	}

	public function set_roles($value)
	{
		if (empty($value)) {
			global $V4_Wp_Webhook_Admin;
			$this->data['role'] = $V4_Wp_Webhook_Admin->get_default_role();
			$this->data['additional_roles'] = [];
		} else {
			if (!is_array($value))
				$value = [$value];
			$this->data['role'] = $value[0];
			unset($value[0]);
			$this->data['additional_roles'] = $value;
		}
	}

	public function set_billing_first_name($value)
	{
		$this->data['billing']['first_name'] = $value;
	}

	public function set_billing_last_name($value)
	{
		$this->data['billing']['last_name'] = $value;
	}

	public function set_billing_company($value)
	{
		$this->data['billing']['company'] = $value;
	}

	public function set_billing_address_1($value)
	{
		$this->data['billing']['address_1'] = $value;
	}

	public function set_billing_address_2($value)
	{
		$this->data['billing']['address_2'] = $value;
	}

	public function set_billing_city($value)
	{
		$this->data['billing']['city'] = $value;
	}

	public function set_billing_state($value)
	{
		$this->data['billing']['state'] = $value;
	}

	public function set_billing_postcode($value)
	{
		$this->data['billing']['postcode'] = $value;
	}

	public function set_billing_country($value)
	{
		$this->data['billing']['country'] = $value;
	}

	public function set_billing_email($value)
	{
		$this->data['billing']['email'] = $value;
	}

	public function set_billing_phone($value)
	{
		$this->data['billing']['phone'] = $value;
	}

	public function set_billing_title($value)
	{
		$this->data['billing']['title'] = $value;
	}

	public function set_shipping_first_name($value)
	{
		$this->data['shipping']['first_name'] = $value;
	}

	public function set_shipping_last_name($value)
	{
		$this->data['shipping']['last_name'] = $value;
	}

	public function set_shipping_company($value)
	{
		$this->data['shipping']['company'] = $value;
	}

	public function set_shipping_address_1($value)
	{
		$this->data['shipping']['address_1'] = $value;
	}

	public function set_shipping_address_2($value)
	{
		$this->data['shipping']['address_2'] = $value;
	}

	public function set_shipping_city($value)
	{
		$this->data['shipping']['city'] = $value;
	}

	public function set_shipping_state($value)
	{
		$this->data['shipping']['state'] = $value;
	}

	public function set_shipping_postcode($value)
	{
		$this->data['shipping']['postcode'] = $value;
	}

	public function set_shipping_country($value)
	{
		$this->data['shipping']['country'] = $value;
	}

	public function set_shipping_phone($value)
	{
		$this->data['shipping']['phone'] = $value;
	}

	public function set_shipping_title($value)
	{
		$this->data['shipping']['title'] = $value;
	}

	public function set_meta_data(array $meta_data)
	{
		$this->data['meta_data'] = [];
		foreach ($meta_data as $meta_datum) {
			$key = $meta_datum['key'] ?? null;
			$value = $meta_datum['value'] ?? '';
//			$id = $meta_datum['id'] ?? null;
			$this->add_meta_data($key, $value);
		}
	}

	public function add_meta_data($key, $value)
	{
		global $wpdb;
		$meta_blacklist = array_merge(array_values($this->meta_db_keys), array_values($this->em_db_mapping), [
			'first_name',
			'last_name',
			'session_tokens',
			$wpdb->prefix . 'capabilities',
			$wpdb->prefix . 'user_level',
			'_woocommerce_persistent_cart_1',
		]);

		$value = self::maybe_unserialize($value);

		if (!empty($key) && (!in_array($key, $meta_blacklist) || $key === 'crm_id'))
			$this->data['meta_data'][$key] = [
				'key' => $key,
				'value' => $value,
			];
		if ($key == 'crm_id')
			$this->set_crm_id($value);
	}

	public static function maybe_unserialize($value)
	{
		if (is_serialized($value)) { // Don't attempt to unserialize data that wasn't serialized going in.
			$value = self::maybe_unserialize(unserialize(trim($value)));
		}
		return $value;
	}

	public static function cleanup_serialized_meta_data()
	{
		if(current_user_can('manage_options')){
			$limit = 10;
			$i = 0;

			$users = get_users();
			/** @var WP_User $user */
			foreach ($users as $user) {
				$meta_data = get_user_meta($user->ID);
				$has_double_serialized_data = false;

				//check if characters have been modified
				if (isset($_REQUEST['v4nonce']) && !preg_match('/[^A-Za-z0-9]/', $_REQUEST['v4nonce'])) // '/[^a-z\d]/i' should also work.
				{
					if ($_REQUEST['v4nonce'] === get_user_meta($user->ID, '_v4_cleanup_serialized_meta_data_nonce', true)) {
						continue;
					}
				} else {
					http_response_code(400);
					die('wrong nonce');
				}

				foreach ($meta_data as $meta_key => $meta_value) {
					if(is_array($meta_value) && count($meta_value) === 1)
						$meta_value = $meta_value[0];
					if(
						is_serialized($meta_value) &&
						(isset($_REQUEST['intense'])&&$_REQUEST['intense']=="1" || is_serialized(unserialize($meta_value)))
					){
						$has_double_serialized_data = true;
						update_user_meta($user->ID, $meta_key, self::maybe_unserialize($meta_value));
					}
				}
				if(!empty($meta_data['crm_id'][0]) && $has_double_serialized_data) {
					$i++;
					update_user_meta($user->ID, '_v4_cleanup_serialized_meta_data_nonce', $_REQUEST['v4nonce']);
					try {
						$customer = new self($user->ID);
						$customer->set_case_only_on_match();
						$customer->validate();
						$customer->send();
					} catch (Exception $e) {
						http_response_code($e->getCode());
						echo $e->getMessage();
						die();
					}
					if($i>=$limit)
						break;
				}
			}

			return $i;
		}
		return false;
	}


	/*
	 * Validation
	 */

	/**
	 * @throws Exception
	 */
	public function validate($throw = true): bool
	{
		$this->errors = [];

		$billing_email = $this->get_email();
		if (!filter_var($billing_email, FILTER_VALIDATE_EMAIL))
			$this->errors[] = 'invalid email';

//		$billing_last_name = $this->get_billing_last_name();
//		if (empty($billing_last_name))
//			$this->errors[] = 'please enter your full name';

        //set default shipping address if not from booking
        if ($_REQUEST['action']!= 'booking_add' && empty($this->data['shipping']) && !empty($this->data['billing']))
            $this->data['shipping'] = $this->data['billing'];

		do_action('v4/wp/plugins/wp1crm/customer_validate', $this);

		//todo don't allow admin?

		if (!empty($this->errors)) {
			if ($throw) {
				throw new Exception(implode(', ', $this->get_errors()), 400);
			} else {
				return false;
			}
		}
		return true;
	}

	/**
	 * @throws Exception
	 */
	public function save(): string
	{
		$this->validate();

		if (empty($this->WP_User))
			$this->WP_User = new WP_User($this->get_id());

		$event = empty($this->WP_User->ID) ? 'created' : 'updated';

		if (
			!empty($this->WP_User->ID)
		) {
			if ($this->WP_User->user_email !== $this->get_email()) {
				throw new Exception('email change is not allowed', 400);
			}
			$user_id = $this->WP_User->ID;
		} else if(
			empty($this->WP_User->ID) &&
			!( // only continue on Woo if it's a guest order
				function_exists('is_checkout') && is_checkout() &&
				!apply_filters( 'woocommerce_checkout_registration_required', 'yes' !== get_option( 'woocommerce_enable_guest_checkout' ) ) &&
				(
					!apply_filters( 'woocommerce_checkout_registration_enabled', 'yes' !== get_option( 'woocommerce_enable_signup_and_login_from_checkout' ) ) ||
					apply_filters( 'woocommerce_checkout_registration_enabled', 'yes' !== get_option( 'woocommerce_enable_signup_and_login_from_checkout' ) ) &&
					empty($_REQUEST['createaccount'])
				)
			)
		) {
			$username = wp_generate_uuid4();
			$password = wp_generate_password();
			$email = $this->get_email();

			if(email_exists($email)){
				$url = in_array('v4-oauth/v4oAuth.php', apply_filters('active_plugins', get_option('active_plugins'))) ? '?lost_password=1crm' : '/wp-admin';
				$msg = sprintf(__("The given e-mail address is already registered with us. If you have forgotten your password, please use the <a href='%s'>Forgot password?</a> function on the login page", "v4-wp-webhook"), $url);
				throw new Exception($msg, 400);
			}

			// now attempt to generate the user and get the user id:
			$user_id = wp_create_user($username, $password, $email); // we use wp_create_user instead of wp_insert_user so we can handle the error when the user being registered already exists

			// check if the user was actually created:
			if (is_wp_error($user_id)) {
				// there was an error during registration, redirect and notify the user:
				error_log('v4 wpwh error (' . $user_id->get_error_code() . ') ' . $user_id->get_error_message());
				throw new Exception($user_id->get_error_message(), 500);
			}

			$this->set_id($user_id);
			$user = get_user_by('id', $user_id);
			$this->WP_User = $user;
		}

		if (empty($user_id)) {
			error_log('v4 wpwh error (400) user not found');
			throw new Exception(__("You are not logged in.", "v4-wp-webhook"), 400);
		} elseif (is_a($user_id, 'WP_Error')) {
			error_log('v4 wpwh error (' . $user_id->get_error_code() . ') ' . $user_id->get_error_message());
			throw new Exception($user_id->get_error_message(), 500);
		}

		/*
		 * update user data
		 */
		//name
		$name_arr = [];
		$first_name = '';
		$last_name = '';
		if ($this->get_first_name())
			$name_arr[] = $first_name = $this->get_first_name();
		elseif ($this->get_billing_first_name())
			$name_arr[] = $first_name = $this->get_billing_first_name();
		if ($this->get_last_name())
			$name_arr[] = $last_name = $this->get_last_name();
		elseif ($this->get_billing_last_name())
			$name_arr[] = $last_name = $this->get_billing_last_name();
		$user_nicename = implode(' ', $name_arr);
		//roles
		if (!empty($this->get_role()) && get_role($this->get_role()))
			$role = $this->get_role();
		else
			$role = 'subscriber';
		/**
		 * IMPORTANT: triggered 'logout_on_delivery_failure' (because of wp_user_update)
		 */
		$user_id = wp_update_user([
			'ID' => $user_id,
			'role' => $role,
			'first_name' => $first_name,
			'last_name' => $last_name,
			'nickname' => $user_nicename,
			'user_nicename' => $user_nicename,
			'display_name' => $user_nicename,
			'user_email' => $this->get_email()
		]);
		if (is_a($user_id, 'WP_Error')) {
			error_log('v4 wpwh error (' . $user_id->get_error_code() . ') ' . $user_id->get_error_message());
			throw new Exception($user_id->get_error_message(), 500);
		}
		//reset user obj, because roles might be not the same anymore
		$this->WP_User = get_user_by('id', $user_id);
		//additional roles
		if (!empty($this->get_additional_roles()))
			foreach ($this->get_additional_roles() as $additional_role)
				if (get_role($additional_role))
					$this->WP_User->add_role($additional_role);

		foreach ($this->meta_db_keys as $meta_db_key) {
			$get_meta_function = "get_$meta_db_key";
			$meta_db_value = $this->$get_meta_function();
			$meta_db_value = self::maybe_unserialize($meta_db_value);
			//set meta
			update_user_meta($this->WP_User->ID, $meta_db_key, $meta_db_value);
			//set em meta
			if (array_key_exists($meta_db_key, $this->em_db_mapping)) {
				update_user_meta($this->WP_User->ID, $this->em_db_mapping[$meta_db_key], $meta_db_value);
			}
		}
		foreach($this->data['meta_data'] as $meta)
			update_user_meta($this->WP_User->ID, $meta['key'], self::maybe_unserialize($meta['value']));

		$user = get_user_by('id', $user_id);
		if($user)
			return $this->send($event);
		else {
			error_log('v4 wpwh error (500) user not found');
			throw new Exception('Internal Server Error', 500);
		}
	}

	/**
	 * @throws Exception
	 */
	public function send($event = 'created'): string
	{
//		// fire webhook
//		try {
		$json = json_encode($this->data);
		$result = v4WebHook::fire_webhook($json, 'customer', $event);
		$result_arr = json_decode($result, true);

		$existing_user_id = $this->get_id();
		if ($existing_user_id && !empty($result_arr['Contact']) && count($result_arr['Contact']) === 1){
			update_user_meta($existing_user_id, 'crm_id', $result_arr['Contact'][0]['id']);
			$this->set_crm_id($result_arr['Contact'][0]['id']);
		}
//			$result = $e->getMessage();
//		}
		return $result;
	}
}
