(function( $ ) {
	'use strict';

	/**
	 * All of the code for your admin-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

	$(document).ready(function () {

        var isDragging = false;
        $(".can-pretty-print")
            .mousedown(function() {
                $(window).mousemove(function() {
                    isDragging = true;
                    $(window).unbind("mousemove");
                });
            })
            .mouseup(function() {
                var wasDragging = isDragging;
                isDragging = false;
                $(window).unbind("mousemove");
                if (!wasDragging) {
                    $(this).toggleClass('pretty-print');
                }
            });

        // $('.can-pretty-print').on('click', function () {
        //     $(this).toggleClass('pretty-print');
        // });
		/*
         * event spaces irrelevant
         */
		var $em_ticket_form_advanced = $('.em-ticket-form-advanced');
		if ($em_ticket_form_advanced.length > 0) {
			$em_ticket_form_advanced.each(function () {
				add_ticket_event_spaces_irrelevant($(this));
			});
		}
		$('#em-tickets-form').find('.form-table').on('change', function () {
			var $em_ticket_form_advanced = $('.em-ticket-form-advanced');
			if ($em_ticket_form_advanced.length > 0) {
				$em_ticket_form_advanced.each(function () {
					if (!$em_ticket_form_advanced.find('.ticket-event-spaces-irrelevant'))
						add_ticket_event_spaces_irrelevant($(this));
				});
			}
		});

		$('#v4-wp1crm-tools-cleanup_serialized_meta').on('submit', function (e) {
			e.preventDefault();
			if(confirm('are you sure to update all user_meta and send customers to 1crm? please backup your databases.')){
				//TODO 
				let $loading = $('<div id="loading-wrapper" style="display: none;"><div id="loading" class="sk-cube-grid">' +
					'<div class="sk-cube sk-cube1"></div>' +
					'<div class="sk-cube sk-cube2"></div>' +
					'<div class="sk-cube sk-cube3"></div>' +
					'<div class="sk-cube sk-cube4"></div>' +
					'<div class="sk-cube sk-cube5"></div>' +
					'<div class="sk-cube sk-cube6"></div>' +
					'<div class="sk-cube sk-cube7"></div>' +
					'<div class="sk-cube sk-cube8"></div>' +
					'<div class="sk-cube sk-cube9"></div>' +
					'</div></div>');
				$(this).append($loading);
				$loading.fadeIn();
				v4_recursive_ajax_result_count = 0;
				$('#v4_recursive_ajax_result').remove();
				$(this).append($('<p id="v4_recursive_ajax_result">wp_users processed: <span id="v4_recursive_ajax_result_count" style="color:green;font-weight:bold;">0</span></p>'));
				v4_send_recursive_ajax(this);
			}
		});

    });

	let v4_recursive_ajax_result_count = 0;
	let v4_send_recursive_ajax = function (form){
		$.ajax({
			type: 'POST',
			url: form.getAttribute('action'),
			data: $(form).serialize(),
			success: function (data, textStatus, XMLHttpRequest) {
				if(XMLHttpRequest.status === 200)
					alert(data);
				if(XMLHttpRequest.status === 202){
					v4_recursive_ajax_result_count += parseInt(data);
					$('#v4_recursive_ajax_result_count').html(v4_recursive_ajax_result_count);
					v4_send_recursive_ajax(form);
				}
			},
			error: function (XMLHttpRequest, textStatus, errorThrown) {
				alert(errorThrown);
				$('#loading-wrapper').fadeOut(function () {
					$(this).remove();
				});
			},
			complete: function (XMLHttpRequest, textStatus) {
				if(XMLHttpRequest.status === 200)
					$('#loading-wrapper').fadeOut(function () {
						$(this).remove();
					});
			}
		});
	}

	var add_ticket_event_spaces_irrelevant = function ($em_ticket_form_advanced) {
		var $ticket_id = $em_ticket_form_advanced.closest('.em-ticket-form-advanced').siblings('.ticket_id'),
			ticket_id = $ticket_id.val(),
			name = $ticket_id.attr('name').replace('ticket_id', 'ticket_event_spaces_irrelevant'),
			$field = $('<div class="ticket-event-spaces-irrelevant"></div>'),
			$label = $('<label>Irrelevant für Gesamtplätze?</label>'),
			$input = $('<input type="checkbox" name="' + name + '" />');

		/** @var {Object} v4em */
		if(typeof v4em !== 'undefined'){
			console.log(v4em);
			/** @var {Object} v4em.tickets */
			v4em.tickets.forEach(function(el){
				/** @var {Object} el.event_spaces_irrelevant */
				if(parseInt(el.id) === parseInt(ticket_id) && el.event_spaces_irrelevant)
					$input.attr('checked', 'checked');
			});
		}

		$field
			.append($label)
			.append($input);
		$em_ticket_form_advanced
			.append($field);
	}

})( jQuery );
