<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       http://www.visual4.de/
 * @since      1.0.0
 *
 * @package    V4_Wp_Webhook
 * @subpackage V4_Wp_Webhook/admin/partials
 */

if (!isset($logs))
    die('wrong entry point');

?>

<h3>Webhook Logs</h3>
<p>click to get a human readable view</p>
<nav id="wpwh-nav">
    <?php
    /**
     * @var $log_page
     * @var $max_log_page
     */
    if ($log_page - 2 > 0) {
        ?>
        <a href="<?= $url . 1 ?>">&VerticalSeparator;&#10092;&#10092;</a>
        <?php
    }
    if ($log_page - 1 > 0) {
        ?>
        <a href="<?= $url . ($log_page - 1) ?>">&#10092;</a>
        <?php
    }

    for ($i = -2; $i < 5; $i++) {
        $this_page = $log_page + $i;
        if ($this_page > 0 && $this_page <= $log_page + 2 && $this_page <= $max_log_page) {
            if ($this_page == $log_page) {
                ?>
                <b><?= $this_page ?></b>
                <?php
            } else {
                ?>
                <a href="<?= $url . $this_page ?>"><?= $this_page ?></a>
                <?php
            }
        }
    }

    if ($log_page + 1 <= $max_log_page) {
        ?>
        <a href="<?= $url . ($log_page + 1) ?>">&#10093;</a>
        <?php
    }
    if ($log_page + 2 <= $max_log_page) {
        ?>
        <a href="<?= $url . $max_log_page ?>">&#10093;&#10093;&VerticalSeparator;</a>
        <?php
    }
    ?>
</nav>
<table id="wpwh-logs">
    <thead>
    <tr>
        <td>Datum</td>
        <td>Request</td>
        <td>Response</td>
        <td>Code</td>
    </tr>
    </thead>
    <tfoot>
    <tr>
        <td>Datum</td>
        <td>Request</td>
        <td>Response</td>
        <td>Code</td>
    </tr>
    </tfoot>
    <tbody>
    <?php
    /**
     * @var $items_offset
     * @var $items_amount
     */
    for ($i = $items_offset; $i < $items_offset + $items_amount && isset($logs[$i]); $i++){
        $request = json_decode($logs[$i]->request);
        $request_pretty = (json_last_error() == JSON_ERROR_NONE) ? json_encode($request, JSON_PRETTY_PRINT) : $logs[$i]->request;
        $response = json_decode($logs[$i]->response);
        $response_pretty = (json_last_error() == JSON_ERROR_NONE) ? json_encode($response, JSON_PRETTY_PRINT) : $logs[$i]->response;
        ?>
        <tr>
            <td><?php echo DateTime::createFromFormat('Y-m-d H:i:s', $logs[$i]->datetime)->format('d.m.Y @ H:i'); ?></td>
            <td class="can-pretty-print"><p><?= $request_pretty ?></p></td>
            <td class="can-pretty-print"><p><?= $response_pretty ?></p></td>
            <td class="can-pretty-print"><p><?= $logs[$i]->http_code ?></p><p><?= $logs[$i]->error ?></p></td>
        </tr>
        <?php
    }
    ?>
    </tbody>
</table>
<nav id="wpwh-nav">
	<?php
	/**
	 * @var $log_page
	 * @var $max_log_page
	 */
	if ($log_page - 2 > 0) {
		?>
        <a href="<?= $url . 1 ?>">&VerticalSeparator;&#10092;&#10092;</a>
		<?php
	}
	if ($log_page - 1 > 0) {
		?>
        <a href="<?= $url . ($log_page - 1) ?>">&#10092;</a>
		<?php
	}

	for ($i = -2; $i < 5; $i++) {
		$this_page = $log_page + $i;
		if ($this_page > 0 && $this_page <= $log_page + 2 && $this_page <= $max_log_page) {
			if ($this_page == $log_page) {
				?>
                <b><?= $this_page ?></b>
				<?php
			} else {
				?>
                <a href="<?= $url . $this_page ?>"><?= $this_page ?></a>
				<?php
			}
		}
	}

	if ($log_page + 1 <= $max_log_page) {
		?>
        <a href="<?= $url . ($log_page + 1) ?>">&#10093;</a>
		<?php
	}
	if ($log_page + 2 <= $max_log_page) {
		?>
        <a href="<?= $url . $max_log_page ?>">&#10093;&#10093;&VerticalSeparator;</a>
		<?php
	}
	?>
</nav>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->
