<?php

require_once __DIR__ . '/aWPWH_REST_EMP.php';

class WPWH_REST_EMP_Event extends aWPWH_REST_EMP
{
	/**
	 * WPWH_REST_EMP_Event constructor.
	 */
	public function __construct()
	{
		parent::__construct('events');
	}

	/**
	 * Register the routes for the objects of the controller.
	 */
	public function register_routes()
	{
		register_rest_route($this->namespace, '/' . $this->base, array(
			array(
				'methods' => WP_REST_Server::READABLE,
				'callback' => array($this, 'get_items'),
				'permission_callback' => array($this, 'get_items_permissions_check'),
				'args' => array(),
			),
			array(
				'methods' => WP_REST_Server::CREATABLE,
				'callback' => array($this, 'create_update_item'),
				'permission_callback' => array($this, 'create_item_permissions_check'),
			),
		));
		register_rest_route($this->namespace, '/' . $this->base . '/(?P<id>[\d]+)', array(
			array(
				'methods' => WP_REST_Server::READABLE,
				'callback' => array($this, 'get_item'),
				'permission_callback' => array($this, 'get_item_permissions_check'),
				'args' => array(
					'context' => array(
						'default' => 'view',
					),
				),
			),
			array(
				'methods' => WP_REST_Server::EDITABLE,
				'callback' => array($this, 'create_update_item'),
				'permission_callback' => array($this, 'update_item_permissions_check'),
			),
			array(
				'methods' => WP_REST_Server::DELETABLE,
				'callback' => array($this, 'delete_item'),
				'permission_callback' => array($this, 'delete_item_permissions_check'),
				'args' => array(
					'force' => array(
						'default' => false,
					),
				),
			),
		));
//		register_rest_route($this->namespace, '/' . $this->base . '/schema', array(
//			'methods' => WP_REST_Server::READABLE,
//			'callback' => array($this, 'get_public_item_schema'),
//		));
	}

	/**
	 * Get a collection of items
	 *
	 * @param WP_REST_Request $request Full data about the request.
	 * @return WP_Error|WP_REST_Response
	 */
	public function get_items($request)
	{
		$data = array(
			'event' => 'allowed'
		);

		return new WP_REST_Response($data, 200);
	}

	/**
	 * Get one item from the collection
	 *
	 * @param WP_REST_Request $request Full data about the request.
	 * @return WP_Error|WP_REST_Response
	 */
	public function get_item($request)
	{
		//get parameters from request
		$params = $request->get_params();

		$EM_Event = new EM_Event($params['id']);

		//return a response or error based on some conditional
		if ($EM_Event->validate()) {
			$data = $this->prepare_item_for_response($EM_Event);
			return new WP_REST_Response($data, 200);
		} else {
			return new WP_Error('not-found', __('Booking'));
		}
	}

	/**
	 * Create or Update one item from the collection
	 *
	 * @param WP_REST_Request $request Full data about the request.
	 * @return WP_Error|WP_REST_Response
	 */
	public function create_update_item($request)
	{
		global $wpwh;

		$data = $this->prepare_item_for_database($request);

		//get parameters from request
		$params = $request->get_params();
		$event_post = get_post($params['id']);
		$EM_Event = new EM_Event($event_post);

		$type = empty($EM_Event->event_id) ? 'create' : 'update';

		try {

			// name
			$EM_Event->post_title = $EM_Event->post_name = $EM_Event->event_name = $EM_Event->name = $data->name;

			//status
			$event_status_mapping = [
				'draft' => null,
				'pending' => 0,
				'publish' => 1,
				'trash' => -1
			];
			if (!empty($data->status)) {
				if (in_array($data->status, array_keys($event_status_mapping)))
					$EM_Event->force_status = $data->status;
			} elseif (!empty($EM_Event->post_status)) {
				//bugfix: re-saving caused a publish
				$EM_Event->force_status = $EM_Event->post_status;
			}

			// event
			$EM_Event->event_name = $data->name;
			$EM_Event->event_spaces = $data->event_spaces;

			// dates
			$start = !empty($data->start_date) ? new EM_DateTime(strtotime($data->start_date)) : null;
			$end = !empty($data->end_date) ? new EM_DateTime(strtotime($data->end_date)) : null;
			$rsvp = !empty($data->rsvp_date) ? new EM_DateTime(strtotime($data->rsvp_date)) : null;
			$EM_Event->event_all_day = false;
			$EM_Event->event_start_date = $start ? $start->getDate() : '';
			$EM_Event->event_start_time = $start ? $start->getTime() : '';
			$EM_Event->event_end_date = $end ? $end->getDate() : '';
			$EM_Event->event_end_time = $end ? $end->getTime() : '';

			// consent. don't know why, but its necessary
			$EM_Event->event_attributes['_consent_given'] = 1;

			// category
			if (!empty($data->category)) {
				// check if term exists
				if (!empty($data->category->id)) {
					$term = get_term($data->category->id, 'event-categories');
				}
				if (empty($term) || is_a($term, 'WP_Error')) {
					if (!term_exists($data->category->name, 'event-categories')) {
						$term = wp_insert_term($data->category->name, 'event-categories');
					} else {
						$term = get_term_by('name', $data->category->name, 'event-categories');
					}
				}
				if (!empty($term) && !is_a($term, 'WP_Error')) {
					wp_set_post_terms($EM_Event->post_id, [$term->term_id], 'event-categories', true);
				}
			}

			//prepare tickets
			$EM_Event->event_rsvp = !empty($data->tickets);

			if ($type == 'create') {
				$EM_Event->post_content = $data->description;
			}

			if ($EM_Event->validate()) {
				$wpwh['do_not_send'] = true;
				$EM_Event->save();
				unset($wpwh['do_not_send']);

				$response = $this->prepare_item_for_response($EM_Event);

				// tickets
				$REST_Ticket_Response = [];
				if($EM_Event->event_rsvp) {
					foreach ($data->tickets as $ticket) {
						//reset event id
						$ticket->event->id = $EM_Event->post_id;

						if(!empty($ticket->id))
							$request = new WP_REST_Request('PUT', '/emp/v1/tickets/' . $ticket->id);
						else
							$request = new WP_REST_Request('POST', '/emp/v1/tickets');

						$request->set_body(json_encode($ticket));
						$ticket_response = rest_do_request($request);
						$server = rest_get_server();
						$data = $server->response_to_data($ticket_response, false);
						$REST_Ticket_Response[] = $data;

					}
				}
				$response['tickets'] = $REST_Ticket_Response;

				return new WP_REST_Response($response, 200);
			} else {
				return new WP_Error('cant-' . $type, print_r($EM_Event->get_errors(), true), array('status' => 400));
			}

		} catch (Exception $e) {
			if ($type == 'create')
				$EM_Event->delete();
			return new WP_Error('cant-' . $type, $e->getMessage(), array('status' => $e->getCode()));
		}

	}

	/**
	 * Delete one item from the collection
	 *
	 * @param WP_REST_Request $request Full data about the request.
	 * @return WP_Error|WP_REST_Response
	 */
	public function delete_item($request)
	{
		global $wpwh;
		$wpwh['do_not_send'] = true;

		$EM_Event = new EM_Event($request['id']);
		if (is_a($EM_Event, 'EM_Event'))
			if ($EM_Event->delete())
				return new WP_REST_Response(true, 200);

		return new WP_Error('cant-delete', __('message', 'text-domain'), array('status' => 500));
	}

	/**
	 * Prepare the item for create or update operation
	 *
	 * @param WP_REST_Request $request Request object
	 * @return WP_Error|object
	 */
	protected function prepare_item_for_database($request)
	{
		$body = $request->get_body();
		return json_decode($body);
	}

	/**
	 * Prepare the item for the REST response
	 *
	 * @param EM_Event $EM_Event
	 * @return mixed
	 */
	public function prepare_item_for_response($EM_Event)
	{
		$data = [
			'id' => $EM_Event->post_id,
			'name' => $EM_Event->event_name,
			'description' => $EM_Event->post_content,
			'status' => $EM_Event->post_status,
			'date_gmt' => $EM_Event->post_date_gmt,
			'start' => $EM_Event->start()->getTimestamp(),
			'end' => $EM_Event->end()->getTimestamp(),
			'rsvp' => $EM_Event->rsvp_end()->getTimestamp(),
			'spaces' => $EM_Event->get_spaces(),
			'spaces_available' => $EM_Event->get_spaces() - $EM_Event->get_bookings()->get_booked_spaces()
		];

		$data['notices'] = $this->notices;

		return $data;
	}
}