<?php

use Events_Manager_WooCommerce\Product as EMWC_Product;

require_once __DIR__ . '/aWPWH_REST_EMP.php';

class WPWH_REST_EMP_Ticket extends aWPWH_REST_EMP
{
    /**
     * WPWH_REST_EMP_Ticket constructor.
     */
    public function __construct()
    {
        parent::__construct('tickets');
    }

    /**
     * Register the routes for the objects of the controller.
     */
    public function register_routes()
    {
        register_rest_route($this->namespace, '/' . $this->base, array(
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'get_items'),
                'permission_callback' => array($this, 'get_items_permissions_check'),
                'args' => array(),
            ),
            array(
                'methods' => WP_REST_Server::CREATABLE,
                'callback' => array($this, 'create_update_item'),
                'permission_callback' => array($this, 'create_item_permissions_check'),
            ),
        ));
        register_rest_route($this->namespace, '/' . $this->base . '/(?P<id>[\d]+)', array(
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'get_item'),
                'permission_callback' => array($this, 'get_item_permissions_check'),
                'args' => array(
                    'context' => array(
                        'default' => 'view',
                    ),
                ),
            ),
            array(
                'methods' => WP_REST_Server::EDITABLE,
                'callback' => array($this, 'create_update_item'),
                'permission_callback' => array($this, 'update_item_permissions_check'),
            ),
            array(
                'methods' => WP_REST_Server::DELETABLE,
                'callback' => array($this, 'delete_item'),
                'permission_callback' => array($this, 'delete_item_permissions_check'),
                'args' => array(
                    'force' => array(
                        'default' => false,
                    ),
                ),
            ),
        ));
//        register_rest_route($this->namespace, '/' . $this->base . '/schema', array(
//            'methods' => WP_REST_Server::READABLE,
//            'callback' => array($this, 'get_public_item_schema'),
//        ));
    }

    /**
     * Get a collection of items
     *
     * @param WP_REST_Request $request Full data about the request.
     * @return WP_Error|WP_REST_Response
     */
    public function get_items($request)
    {
        $data = array(
            'tickets' => 'allowed'
        );

        return new WP_REST_Response($data, 200);
    }

    /**
     * Get one item from the collection
     *
     * @param WP_REST_Request $request Full data about the request.
     * @return WP_Error|WP_REST_Response
     */
    public function get_item($request)
    {
        //get parameters from request
        $params = $request->get_params();

        $EM_Ticket = new EM_Ticket($params['id']);

        //return a response or error based on some conditional
        if ($EM_Ticket->validate()) {
            $data = $this->prepare_item_for_response($EM_Ticket);
            return new WP_REST_Response($data, 200);
        } else {
            return new WP_Error('not-found', __('Booking'));
        }
    }

    /**
     * Create or Update one item from the collection
     *
     * @param WP_REST_Request $request Full data about the request.
     * @return WP_Error|WP_REST_Response
     */
    public function create_update_item($request)
    {
        global $wpwh;

        $data = $this->prepare_item_for_database($request);

		//get parameters from request
		$params = $request->get_params();
		$EM_Ticket = new EM_Ticket($params['id']);

        $EM_Ticket->get_event();

        $type = empty($EM_Ticket->ticket_id) ? 'create' : 'update';

        try {
            $this->add_ticket_data($EM_Ticket, $data);

            //save
            if ($EM_Ticket->validate()) {
                $wpwh['do_not_send'] = true;
                $ticked_saved = $EM_Ticket->save();
                unset($wpwh['do_not_send']);

                //START bug workaround, write ticket name and description
                if ($ticked_saved) {
                    global $wpdb;
                    $table = EM_TICKETS_TABLE;
                    $set_array = [];
                    if (isset($data->name))
                        $set_array[] = "ticket_name='" . esc_sql($data->name) . "'";
                    if (isset($data->description))
                        $set_array[] = "ticket_description='" . esc_sql($data->description) . "'";
                    if(!empty($set_array)){
                        $sql = "UPDATE $table SET ".implode(', ', $set_array)." WHERE ticket_id={$EM_Ticket->ticket_id}";
                        $wpdb->query($sql);
                    }
                }
                //END bug workaround

                //woocommerce
                if (class_exists('Events_Manager_WooCommerce\Product')) {
                    $product_id = EMWC_Product::get_ticket_product_id($EM_Ticket);
                    $WC_Product = new WC_Product_Variation($product_id);
                    $WC_Product->set_price($data->price);
                    $WC_Product->set_sale_price($data->price);
                    $WC_Product->set_regular_price(max($data->price, $data->list_price));
                    if (isset($data->tax_class))
                        $WC_Product->set_tax_class($data->tax_class);
                    $WC_Product->save();
                }

                $data = $this->prepare_item_for_response($EM_Ticket);
                return new WP_REST_Response($data, 200);

            } else
                $this->error('ticket__invalid', print_r($EM_Ticket->get_errors(), true));

        } catch (Exception $e) {
            if ($type == 'create')
                $EM_Ticket->delete();
            if (!empty($this->error))
                return new WP_Error($this->error['code'], $this->error['message'], array('status' => $this->error['status']));
            else
                return new WP_Error('cant-' . $type, $e->getMessage(), array('status' => $e->getCode()));
        }

//        if ($type == 'create')
//            $EM_Ticket->delete();
//        return new WP_Error('cant-' . $type, print_r($EM_Ticket->get_errors(), true), array('status' => 500));

//        return new WP_Error('cant-create', 'tickets not supported', array('status' => 500));
    }

    /**
     * @param EM_Ticket $EM_Ticket
     * @param $data
     * @throws Exception
     */
    private function add_ticket_data(&$EM_Ticket, $data)
    {
        global $wpwh;

        //get event
		$event_post = get_post($data->event->id);
		$EM_Event = new EM_Event($event_post);

        //error if booking doesn't exist
        if (empty($EM_Event->event_id)) {
            $this->error('ticket__event_missing', json_encode($data->booking));
            return;
        }

        if(!$EM_Event->event_rsvp){
        	$EM_Event->event_rsvp = 1;
			$EM_Event->force_status = $EM_Event->post_status;
			if ($EM_Event->validate()) {
				$wpwh['do_not_send'] = true;
				$EM_Event->save();
				unset($wpwh['do_not_send']);
			} else {
				$this->error('ticket__event_update_failed', json_encode($data->booking));
			}
		}

        //default data
        $EM_Ticket->name = $data->name;
        $EM_Ticket->description = $data->description;
        $EM_Ticket->ticket_spaces = $data->spaces_limit;
        $EM_Ticket->ticket_meta['event_spaces_irrelevant'] = $data->spaces_irrelevant;
        $EM_Ticket->ticket_price = $data->price;
        $EM_Ticket->event_id = $EM_Event->event_id;

		if(!empty($data->crm_id)){
			$EM_Ticket->ticket_meta['crm_id'] = $data->crm_id;
		}

        //roles
		if(!empty($data->roles)){
			$EM_Ticket->ticket_members = 1;
			$EM_Ticket->ticket_members_roles = $data->roles;
		} else {
			$EM_Ticket->ticket_members = 0;
			$EM_Ticket->ticket_members_roles = [];
		}
		$EM_Ticket->ticket_guests = 0;
    }

    /**
     * Delete one item from the collection
     *
     * @param WP_REST_Request $request Full data about the request.
     * @return WP_Error|WP_REST_Response
     */
    public function delete_item($request)
    {
		global $wpwh;

		$wpwh['do_not_send'] = true;

        $EM_Ticket = new EM_Ticket($request['id']);
        if (is_a($EM_Ticket, 'EM_Booking'))
            if ($EM_Ticket->delete())
                return new WP_REST_Response(true, 200);

        return new WP_Error('cant-delete', __('message', 'text-domain'), array('status' => 500));
    }

    /**
     * Prepare the item for create or update operation
     *
     * @param WP_REST_Request $request Request object
     * @return WP_Error|object
     */
    protected function prepare_item_for_database($request)
    {
        $body = $request->get_body();
        return json_decode($body);
    }

    /**
     * Prepare the item for the REST response
     *
     * @param EM_Ticket $EM_Ticket
     * @return mixed
     */
    public function prepare_item_for_response($EM_Ticket)
    {
        $data = [
            'id' => $EM_Ticket->ticket_id,
            'name' => $EM_Ticket->ticket_name,
            'description' => $EM_Ticket->ticket_description,
            'price' => $EM_Ticket->ticket_price,
            'start' => $EM_Ticket->start()->getTimestamp(),
            'end' => $EM_Ticket->end()->getTimestamp(),
            'spaces' => $EM_Ticket->ticket_spaces,
            'spaces_available' => $EM_Ticket->ticket_spaces - $EM_Ticket->get_booked_spaces()
        ];

		if(!empty($EM_Ticket->ticket_meta['crm_id'])){
			$data['crm_id'] = $EM_Ticket->ticket_meta['crm_id'];
		}
        
        $data['notices'] = $this->notices;
        
        return $data;
    }
}