<?php

require_once __DIR__ . '/aWPWH_REST_EMP.php';

class WPWH_REST_EMP_Ticket_Booking extends aWPWH_REST_EMP
{
    /**
     * WPWH_REST_EMP_Ticket_Booking constructor.
     */
    public function __construct()
    {
        parent::__construct('tickets/bookings');
    }

    /**
     * Register the routes for the objects of the controller.
     */
    public function register_routes()
    {
        register_rest_route($this->namespace, '/' . $this->base, array(
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'get_items'),
                'permission_callback' => array($this, 'get_items_permissions_check'),
                'args' => array(),
            ),
            array(
                'methods' => WP_REST_Server::CREATABLE,
                'callback' => array($this, 'create_update_item'),
                'permission_callback' => array($this, 'create_item_permissions_check'),
            ),
        ));
        register_rest_route($this->namespace, '/' . $this->base . '/(?P<id>[\d]+)', array(
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'get_item'),
                'permission_callback' => array($this, 'get_item_permissions_check'),
                'args' => array(
                    'context' => array(
                        'default' => 'view',
                    ),
                ),
            ),
            array(
                'methods' => WP_REST_Server::EDITABLE,
                'callback' => array($this, 'create_update_item'),
                'permission_callback' => array($this, 'update_item_permissions_check'),
            ),
            array(
                'methods' => WP_REST_Server::DELETABLE,
                'callback' => array($this, 'delete_item'),
                'permission_callback' => array($this, 'delete_item_permissions_check'),
                'args' => array(
                    'force' => array(
                        'default' => false,
                    ),
                ),
            ),
        ));
//        register_rest_route($this->namespace, '/' . $this->base . '/schema', array(
//            'methods' => WP_REST_Server::READABLE,
//            'callback' => array($this, 'get_public_item_schema'),
//        ));
    }

    /**
     * Get a collection of items
     *
     * @param WP_REST_Request $request Full data about the request.
     * @return WP_Error|WP_REST_Response
     */
    public function get_items($request)
    {
        $data = array(
            'tickets_bookings' => 'allowed'
        );

        return new WP_REST_Response($data, 200);
    }

    /**
     * Get one item from the collection
     *
     * @param WP_REST_Request $request Full data about the request.
     * @return WP_Error|WP_REST_Response
     */
    public function get_item($request)
    {
        //get parameters from request
        $params = $request->get_params();

        $EM_Ticket_Booking = new EM_Ticket_Booking($params['id']);

        //return a response or error based on some conditional
        if ($EM_Ticket_Booking->validate()) {
            $data = $this->prepare_item_for_response($EM_Ticket_Booking);
            return new WP_REST_Response($data, 200);
        } else {
            return new WP_Error('not-found', __('Booking'));
        }
    }

    /**
     * Create or Update one item from the collection
     *
     * @param WP_REST_Request $request Full data about the request.
     * @return WP_Error|WP_REST_Response
     */
    public function create_update_item($request)
    {
        global $wpwh;

        $data = $this->prepare_item_for_database($request);
        $EM_Ticket_Booking = new EM_Ticket_Booking($request['id']);

        $EM_Ticket_Booking->get_ticket();
        $EM_Ticket_Booking->get_booking();

        $type = empty($EM_Ticket_Booking->ticket_booking_id) ? 'create' : 'update';

        try {
            $this->add_ticket_booking_data($EM_Ticket_Booking, $data);
        } catch (Exception $e) {
            if ($type == 'create')
                $EM_Ticket_Booking->delete();
            if (!empty($this->error))
                return new WP_Error($this->error['code'], $this->error['message'], array('status' => $this->error['status']));
            else
                return new WP_Error('cant-' . $type, $e->getMessage(), array('status' => 500));
        }

//        if ($EM_Ticket_Booking->validate()) {
//            //success
//            $wpwh['do_not_send'] = true;
//            $EM_Ticket_Booking->save();
//            unset($wpwh['do_not_send']);
//
//            //save booking
//            $EM_Booking = $EM_Ticket_Booking->get_booking();
////            $EM_Tickets_Bookings = $EM_Booking->tickets_bookings;
//            if ($EM_Booking->validate()) {
//                //success
//                $wpwh['do_not_send'] = true;
//                $EM_Booking->save();
//                unset($wpwh['do_not_send']);
//            }
//
//            $data = $this->prepare_item_for_response($EM_Ticket_Booking);
//            return new WP_REST_Response($data, 200);
//        }

        $EM_Booking = $EM_Ticket_Booking->get_booking();
        $EM_Booking->get_spaces();
        $EM_Booking->get_price();
        $EM_Booking->get_tickets_bookings();

        //event
        $EM_Booking->event = em_get_event($data->event->id, 'post_id');
        $EM_Booking->event_id = $EM_Booking->event->event_id;

        if ($EM_Booking->validate()) {
            //success
            $wpwh['do_not_send'] = true;
            $EM_Booking->save();
            unset($wpwh['do_not_send']);

            $data = $this->prepare_item_for_response($EM_Ticket_Booking);
            return new WP_REST_Response($data, 200);
        }

        if ($type == 'create')
            $EM_Booking->delete();
        return new WP_Error('cant-' . $type, print_r($EM_Booking->get_errors(), true), array('status' => 500));
    }

    /**
     * @param EM_Ticket_Booking $EM_Ticket_Booking
     * @param $data
     * @throws Exception
     */
    private function add_ticket_booking_data(&$EM_Ticket_Booking, $data)
    {
        //get booking
        $EM_Booking = new EM_Booking($data->booking->id);
        //error if booking doesn't exist
        if (empty($EM_Booking->booking_id)) {
            $this->error('ticket_booking__booking_missing', json_encode($data->booking));
            return;
        }

        //get ticket
        $EM_Ticket = new EM_Ticket($data->ticket->id);
        if (!$EM_Ticket->validate())
            throw new Exception(print_r($EM_Ticket->get_errors(), true));
        //error if ticket doesn't exist
        if (empty($EM_Ticket->ticket_id)) {
            $this->error('ticket_booking__ticket_missing', json_encode($data->ticket));
            return;
        }

        //delete ticket
        if (empty($data->spaces)) {
            $EM_Ticket_Booking->delete();
            return;
        }

        //default data
        $EM_Ticket_Booking->ticket_booking_spaces = $data->spaces;
        $EM_Ticket_Booking->spaces = $data->spaces; // dynamic field declaration necessary because of a bug in EventsManager
        $EM_Ticket_Booking->ticket_booking_price = $data->price !== null ? $data->price : $EM_Ticket->get_price();
        $EM_Ticket_Booking->booking_id = $EM_Booking->booking_id;
        $EM_Ticket_Booking->ticket_id = $EM_Ticket->ticket_id;

        //rel objects
        $EM_Ticket_Booking->ticket = $EM_Ticket;
        $EM_Ticket_Booking->booking = $EM_Booking;

        //add to tickets bookings
        if ($EM_Ticket_Booking->validate()) {

            //tickets_bookings
            if(empty($EM_Booking->tickets_bookings))
                $EM_Booking->get_tickets_bookings();

            $added = $EM_Booking->tickets_bookings->add($EM_Ticket_Booking, true);
            if (!$added)
                foreach ($EM_Booking->tickets_bookings->get_errors() as $error)
                    $EM_Booking->add_error($error);

        } else
            $this->error('ticket_booking__invalid', print_r($EM_Ticket_Booking->get_errors(), true));


//        //tickets bookings
//        $EM_Tickets_Bookings = new EM_Tickets_Bookings($EM_Booking->booking_id);
//        $EM_Booking->tickets_bookings = $EM_Tickets_Bookings;
//        $EM_Booking->tickets_bookings->spaces = $data->spaces;
//        $EM_Booking->tickets_bookings->price = $data->price;
//        $EM_Booking->tickets = new EM_Tickets($EM_Booking->event_id);
//
//        //get ticket
//        $EM_Ticket = new EM_Ticket($data->ticket->id);
//        if (!$EM_Ticket->validate())
//            throw new Exception(print_r($EM_Ticket->get_errors(), true));
//
//        //notice and continue with next ticket_booking if ticket doesn't exist
//        if (empty($EM_Ticket->ticket_id)) {
//            $this->error('ticket_booking__ticket_missing', json_encode($data->ticket), 404);
//        }
//
//        //default data
//        /**
//         * @var EM_Ticket_Booking $EM_Ticket_Booking
//         * @var EM_Ticket_Booking $em_tb
//         */
//        $existing_ticket_booking = false;
//        $EM_Ticket_Booking = null;
//        if (!empty($EM_Ticket->ticket_id)) {
//            foreach ($EM_Booking->tickets_bookings->tickets_bookings as $em_tb) {
//                if ($em_tb->ticket_id == $data->id && $em_tb->validate()) {
//                    $existing_ticket_booking = true;
//                    $EM_Ticket_Booking = $em_tb;
//                    break;
//                }
//            }
//        }
//        if (!$existing_ticket_booking) {
//            $data_data = [
//                'ticket_booking_spaces' => $data->spaces,
//                'ticket_booking_price' => $data->price,
//                'booking_id' => $EM_Booking->booking_id,
//                'ticket_id' => $EM_Ticket->ticket_id,
//            ];
//            $EM_Ticket_Booking = new EM_Ticket_Booking($data_data);
//        }
//
//        //rel objects
//        $EM_Ticket_Booking->ticket = $EM_Ticket;
//        $EM_Ticket_Booking->booking = $EM_Booking;
//
//        //add to tickets bookings
//        if ($EM_Ticket_Booking->validate()) {
//            $added = $EM_Booking->tickets_bookings->add($EM_Ticket_Booking, true);
//            if (!$added)
//                foreach ($EM_Booking->tickets_bookings->get_errors() as $error)
//                    $EM_Booking->add_error($error);
//        } else
//            $this->error('ticket_booking__invalid', print_r($EM_Ticket_Booking->get_errors(), true), 400);


    }

    /**
     * Delete one item from the collection
     *
     * @param WP_REST_Request $request Full data about the request.
     * @return WP_Error|WP_REST_Response
     */
    public function delete_item($request)
    {
        $wpwh['do_not_send'] = true;

        $EM_Ticket_Booking = new EM_Ticket_Booking($request['id']);
        if (is_a($EM_Ticket_Booking, 'EM_Ticket_Booking')) {
        	$result = $EM_Ticket_Booking->delete();
			if ($result !== false) {
				return new WP_REST_Response(true, 200);
			} else {
				$errors = $EM_Ticket_Booking->get_errors();
				return new WP_Error('cant-delete', __('EM_Ticket_Booking delete failed', 'v4-wp-webhook'), array('status' => 400));
//				return new WP_Error('cant-delete', implode(';', $errors), array('status' => 500));
			}
		} else {
			return new WP_Error('cant-delete', __('EM_Ticket_Booking not found', 'v4-wp-webhook'), array('status' => 400));
		}


//        return new WP_Error('cant-delete', __('should not have happened', 'text-domain'), array('status' => 500));
    }

    /**
     * Prepare the item for create or update operation
     *
     * @param WP_REST_Request $request Request object
     * @return WP_Error|object
     */
    protected function prepare_item_for_database($request)
    {
        $body = $request->get_body();
        $data = json_decode($body);
        return $data;
    }

    /**
     * Prepare the item for the REST response
     *
     * @param EM_Ticket_Booking $EM_Ticket_Booking
     * @return mixed
     */
    public function prepare_item_for_response($EM_Ticket_Booking)
    {
        $EM_Ticket = $EM_Ticket_Booking->get_ticket();

        $data = [
            'id' => $EM_Ticket_Booking->ticket_booking_id,
            'price' => $EM_Ticket_Booking->ticket_booking_price,
            'spaces' => $EM_Ticket_Booking->ticket_booking_spaces,
            'ticket' => [
                'id' => $EM_Ticket->ticket_id,
                'name' => $EM_Ticket->ticket_name,
                'description' => $EM_Ticket->ticket_description,
                'price' => $EM_Ticket->ticket_price,
                'start' => $EM_Ticket->start()->getTimestamp(),
                'end' => $EM_Ticket->end()->getTimestamp(),
                'spaces' => $EM_Ticket->ticket_spaces,
                'spaces_available' => $EM_Ticket->ticket_spaces - $EM_Ticket->get_booked_spaces()
            ]
        ];

        $data['notices'] = $this->notices;

        return $data;
    }
}