<?php

require_once ABSPATH . 'wp-content/plugins/v4-wp-webhook/admin/rest_api/auth/WPWH_REST_Authentication.php';
require_once ABSPATH . 'wp-content/plugins/v4-wp-webhook/admin/class-v4-wp-webhook-admin.php';

abstract class aWPWH_REST_EMP
{
    /**
     * @var WPWH_REST_Authentication
     */
    protected $auth;
    /**
     * @var V4_Wp_Webhook_Admin
     */
    protected $v4_wp_webhook_admin;

    protected $post_type;

    protected $notices = [];
    protected $error = [];

    protected $version;
    protected $namespace;
    protected $base;

    /**
     * aWPWH_REST_EMP constructor.
     * @param $base
     */
    public function __construct($base)
    {
        $this->version = '1';
        $this->namespace = 'emp/v' . $this->version;
        $this->base = $base;
        $this->post_type = 'event';

        # get required Classes
        $this->auth = new WPWH_REST_Authentication();
        $this->v4_wp_webhook_admin = new V4_Wp_Webhook_Admin('v4-wp-webhook', '1.0.0');

        $this->register_routes();
    }


    abstract public function register_routes();
    abstract protected function prepare_item_for_database($request);
    abstract public function prepare_item_for_response($obj);


    /**
     * Check if a given request has access to get items
     *
     * @param WP_REST_Request $request Full data about the request.
     * @return WP_Error|bool
     */
    public function get_items_permissions_check($request)
    {
        $post_type_object = get_post_type_object($this->post_type);
        return current_user_can($post_type_object->cap->read_private_posts);
    }

    /**
     * Check if a given request has access to get a specific item
     *
     * @param WP_REST_Request $request Full data about the request.
     * @return WP_Error|bool
     */
    public function get_item_permissions_check($request)
    {
        $post_type_object = get_post_type_object($this->post_type);
        return current_user_can($post_type_object->cap->read_private_posts, $request['id']);
    }

    /**
     * Check if a given request has access to create items
     *
     * @param WP_REST_Request $request Full data about the request.
     * @return WP_Error|bool
     */
    public function create_item_permissions_check($request)
    {
        $post_type_object = get_post_type_object($this->post_type);
        return current_user_can($post_type_object->cap->publish_posts, $request['id']);
    }

    /**
     * Check if a given request has access to update a specific item
     *
     * @param WP_REST_Request $request Full data about the request.
     * @return WP_Error|bool
     */
    public function update_item_permissions_check($request)
    {
        $post_type_object = get_post_type_object($this->post_type);
        return current_user_can($post_type_object->cap->edit_posts, $request['id']);
    }

    /**
     * Check if a given request has access to delete a specific item
     *
     * @param WP_REST_Request $request Full data about the request.
     * @return WP_Error|bool
     */
    public function delete_item_permissions_check($request)
    {
        $post_type_object = get_post_type_object($this->post_type);
        return current_user_can($post_type_object->cap->delete_posts, $request['id']);
    }

    /**
     * @param $code
     * @param $message
     * @param int $status
     */
    public function notice($code, $message, $status = 200)
    {
        $this->notices[] = [
            'code' => $code,
            'message' => $message,
            'status' => $status
        ];
    }

    /**
     * @param $code
     * @param $message
     * @param int $status
     * @throws Exception
     */
    public function error($code, $message, $status = 400)
    {
        $this->error = [
            'code' => $code,
            'message' => $message,
            'status' => $status
        ];
        throw new Exception($message, $status);
    }

    /**
     * Prepare a response for inserting into a collection of responses.
     *
     * This is copied from WP_REST_Controller class in the WP REST API v2 plugin.
     *
     * @param WP_REST_Response $response Response object.
     * @return array|WP_REST_Response Response data, ready for insertion into collection data.
     */
    public function prepare_response_for_collection($response)
    {
        if (!($response instanceof WP_REST_Response)) {
            return $response;
        }

        $data = (array)$response->get_data();
        $server = rest_get_server();

        if (method_exists($server, 'get_compact_response_links')) {
            $links = call_user_func(array($server, 'get_compact_response_links'), $response);
        } else {
            $links = call_user_func(array($server, 'get_response_links'), $response);
        }

        if (!empty($links)) {
            $data['_links'] = $links;
        }

        return $data;
    }

}
