<?php

require_once 'emp/v1/WPWH_REST_EMP_Booking.php';
require_once 'emp/v1/WPWH_REST_EMP_Event.php';
require_once 'emp/v1/WPWH_REST_EMP_Ticket.php';
require_once 'emp/v1/WPWH_REST_EMP_Ticket_Booking.php';

// Function to register our new routes from the controller.
function register_custom_rest_routes()
{
    $wpwh_rest_emp_booking = new WPWH_REST_EMP_Booking();
    $wpwh_rest_emp_event = new WPWH_REST_EMP_Event();
    $wpwh_rest_emp_ticket = new WPWH_REST_EMP_Ticket();
    $wpwh_rest_emp_ticket_booking = new WPWH_REST_EMP_Ticket_Booking();
}

add_action('rest_api_init', 'register_custom_rest_routes');

// Let us use the WooCommerce authentication for our emp endpoint
function wc_rest_auth_allow_emp_endpoint($is_rest_request)
{
    $rest_prefix = trailingslashit( rest_get_url_prefix() );

    // Check if emp endpoint.
    $emp = ( false !== strpos( $_SERVER['REQUEST_URI'], $rest_prefix . 'emp/' ) );

    return $is_rest_request || $emp;
}

add_filter('woocommerce_rest_is_request_to_rest_api', 'wc_rest_auth_allow_emp_endpoint');