<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       http://www.visual4.de/
 * @since      1.0.0
 *
 * @package    V4_Wp_Webhook
 * @subpackage V4_Wp_Webhook/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    V4_Wp_Webhook
 * @subpackage V4_Wp_Webhook/includes
 * @author     visual4 <info@visual4.de>
 */
class V4_Wp_Webhook_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {
        load_plugin_textdomain(
			'v4-wp-webhook',
            false,
            dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
