<?php

/**
 * Created by PhpStorm.
 * User: Anton_Haas
 * Date: 09.11.2016
 * Time: 11:07
 */
class V4_Wp_Webhook_Settings
{
    /**
     * Holds the values to be used in the fields callbacks
     */
    private $options;

    /**
     * Start up
     */
    public function __construct()
    {
        add_action('admin_menu', array($this, 'add_plugin_page'), 20);
        add_action('admin_init', array($this, 'page_init'));
    }

    /**
     * Add options page
     */
    public function add_plugin_page()
    {
        // create new top-level menu
        if (!empty ($GLOBALS['admin_page_hooks']['wp1crm-extensions']))
            add_submenu_page('wp1crm-extensions', 'v4 WP Webhook', 'v4 WP Webhook', 'manage_options', 'v4-wpwh-admin', array($this, 'create_admin_page'));
        else {
            // This page will be under "Settings"
            add_options_page(
                'Settings Admin',
                'v4 WP Webhook',
                'manage_options',
                'v4-wpwh-admin',
                array($this, 'create_admin_page')
            );
        }
    }

    /**
     * Options page callback
     */
    public function create_admin_page()
    {
        // Set class property
        $this->options = get_option('v4_wpwh');
        ?>
        <div class="wrap">
            <h1>v4 WP Webhook Settings</h1>
            <?php
			$this->settings_errors();
            ?>
            <form method="post" action="options.php">
                <?php
                // This prints out all hidden setting fields
                settings_fields('v4_wpwh_group');
                do_settings_sections('v4-wpwh-admin');
                submit_button();
                ?>
            </form>
            <?php
            //get DB Data
            /** @var wpdb $wpdb */
            global $wpdb;
            $items_amount = 20;
            $log_page = !empty($_GET['log_page']) && $_GET['log_page'] > 1 ? (int)$_GET['log_page'] : 1;
            $items_offset = $log_page * $items_amount - $items_amount;
            //            $logs = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}wpwh_log ORDER BY id DESC WHERE error IS NULL");
            //            $errors = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}wpwh_log ORDER BY id DESC WHERE error IS NOT NULL");
            $logs = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}wpwh_log ORDER BY id DESC");
            $max_log_page = ceil(count($logs) / $items_amount);
            $url = get_home_url() . '/wp-admin/admin.php?page=v4-wpwh-admin&log_page=';

            include __DIR__ . '/../admin/partials/v4-wp-webhook-admin-display.php';
            ?>
        </div>
        <?php
    }

	public function settings_errors()
	{
		$settings_errors = get_settings_errors();
		foreach ($settings_errors as $key => $details) {

			if (
				$details['code'] == 'consumer_key' ||
				$details['code'] == 'consumer_secret'
			)
				continue;

			if ('updated' === $details['type'])
				$details['type'] = 'success';

			if (in_array($details['type'], array('error', 'success', 'warning', 'info')))
				$details['type'] = 'notice-' . $details['type'];

			$css_id = sprintf(
				'setting-error-%s',
				esc_attr($details['code'])
			);
			$css_class = sprintf(
				'notice %s settings-error is-dismissible',
				esc_attr($details['type'])
			);

			echo "<div id='$css_id' class='$css_class'> \n";
			echo "<p><strong>{$details['message']}</strong></p>";
			echo "</div> \n";
		}
	}

    /**
     * Register and add settings
     */
    public function page_init()
    {

        register_setting(
            'v4_wpwh_group', // Option group
            'v4_wpwh', // Option name
            array($this, 'sanitize') // Sanitize
        );

        add_settings_section(
            'wpwh_base_setting', // ID
            'Basic Settings', // Title
            array($this, 'print_section_info'), // Callback
            'v4-wpwh-admin' // Page
        );
        add_settings_section(
            'wpwh_auth_setting', // ID
            'Authentication', // Title
            array($this, 'print_section_info'), // Callback
            'v4-wpwh-admin' // Page
        );

        //Fields
        add_settings_field(
            '1crm_url',
            '1CRM URL',
            array($this, 'callback_1crm_url'),
            'v4-wpwh-admin',
            'wpwh_base_setting'
        );
		add_settings_field(
			'allow_instant_login',
			'allow instant login on register',
			array($this, 'callback_allow_instant_login'),
			'v4-wpwh-admin',
			'wpwh_base_setting'
		);
		add_settings_field(
			'default_role',
			'Default Role',
			array($this, 'callback_default_role'),
			'v4-wpwh-admin',
			'wpwh_base_setting'
		);
        add_settings_field(
            'sync_events',
            'Sync Events',
            array($this, 'callback_sync_events'),
            'v4-wpwh-admin',
            'wpwh_base_setting'
        );
        add_settings_field(
            'sync_event_bookings',
            'Sync Event Bookings',
            array($this, 'callback_sync_event_bookings'),
            'v4-wpwh-admin',
            'wpwh_base_setting'
        );
        add_settings_field(
            'use_wpwh_register_fields',
            'Use v4 WP WebHook register fields for events',
            array($this, 'callback_use_wpwh_register_fields'),
            'v4-wpwh-admin',
            'wpwh_base_setting'
        );
        add_settings_field(
            'show_privacy_if_logged_in',
            'Show privacy checkbox, even if you are logged in. For Events with WebHook register fields.',
            array($this, 'callback_show_privacy_if_logged_in'),
            'v4-wpwh-admin',
            'wpwh_base_setting'
        );
        add_settings_field(
            'alt_address',
            'Allow alternative Address in WooCommerce checkout and disallow main address change.',
            array($this, 'callback_alt_address'),
            'v4-wpwh-admin',
            'wpwh_base_setting'
        );
		add_settings_field(
			'recaptcha_site_key',
			'Google reCaptcha Site Key',
			array($this, 'recaptcha_site_key'),
			'v4-wpwh-admin',
			'wpwh_base_setting'
		);
		add_settings_field(
			'recaptcha_secret_key',
			'Google reCaptcha Secret Key',
			array($this, 'recaptcha_secret_key'),
			'v4-wpwh-admin',
			'wpwh_base_setting'
		);
        add_settings_field(
            'consent_privacy_policy',
            'Privacy policy',
            array($this, 'consent_privacy_policy'),
            'v4-wpwh-admin',
            'wpwh_base_setting'
        );
        add_settings_field(
            'consent_terms_of_participation',
            'Terms and conditions',
            array($this, 'consent_terms_of_participation'),
            'v4-wpwh-admin',
            'wpwh_base_setting'
        );

        //auth
        add_settings_field(
            'secret',
            'Request Secret',
            array($this, 'callback_secret'),
            'v4-wpwh-admin',
            'wpwh_auth_setting'
        );
        add_settings_field(
            'consumer_key',
            'Consumer Key',
            array($this, 'callback_consumer_key'),
            'v4-wpwh-admin',
            'wpwh_auth_setting'
        );
//        add_settings_field(
//            'consumer_key_display',
//            'Consumer Key',
//            array($this, 'callback_consumer_key'),
//            'v4-wpwh-admin',
//            'wpwh_auth_setting'
//        );
        add_settings_field(
            'consumer_secret',
            'Consumer Secret',
            array($this, 'callback_consumer_secret'),
            'v4-wpwh-admin',
            'wpwh_auth_setting'
        );
//        add_settings_field(
//            'consumer_secret_display',
//            'Consumer Secret',
//            array($this, 'callback_consumer_secret'),
//            'v4-wpwh-admin',
//            'wpwh_auth_setting'
//        );

        $v4_wpwh = get_option('v4_wpwh');
        if (
            isset($v4_wpwh['consumer_key']) &&
            isset($v4_wpwh['consumer_secret'])
        )
            add_settings_field(
                'regen_keys',
                'regenerate Key/Secret',
                array($this, 'callback_regen_keys'),
                'v4-wpwh-admin',
                'wpwh_auth_setting'
            );
        add_settings_field(
            'user',
            'User',
            array($this, 'callback_user'),
            'v4-wpwh-admin',
            'wpwh_auth_setting'
        );
    }

    /**
     * Sanitize each setting field as needed
     *
     * @param array $input Contains all settings fields as array keys
     * @return array $new_input
     */
    public function sanitize($input)
    {
        $new_input = array();
        $v4_wpwh = get_option('v4_wpwh');

        if (isset($input['1crm_url']))
            $new_input['1crm_url'] = filter_var($input['1crm_url'], FILTER_SANITIZE_URL);
        if (isset($input['secret']))
            $new_input['secret'] = $input['secret']; //no sanitize for secret
        if (isset($input['recaptcha_site_key']))
            $new_input['recaptcha_site_key'] = $input['recaptcha_site_key']; //no sanitize for recaptcha_site_key
        if (isset($input['recaptcha_secret_key']))
            $new_input['recaptcha_secret_key'] = $input['recaptcha_secret_key']; //no sanitize for recaptcha_secret_key
        if (isset($input['consent_privacy_policy']))
            $new_input['consent_privacy_policy'] = $input['consent_privacy_policy']; //no sanitize for consent_privacy_policy
        if (isset($input['consent_terms_of_participation']))
            $new_input['consent_terms_of_participation'] = $input['consent_terms_of_participation']; //no sanitize for consent_terms_of_participation

        $regen_keys = (isset($input['regen_keys']) && $input['regen_keys'] == 'on');
        $new_input['user'] = is_numeric($input['user']) ? $input['user'] : false;
        $new_input['default_role'] = get_role($input['default_role']) ? $input['default_role'] : 'subscriber';

        if (!isset($v4_wpwh['consumer_key']) || $regen_keys) {
            $consumer_key = 'v4wpwh_ck_' . str_replace('-', '', wp_generate_uuid4());
            add_settings_error(
                'v4_wpwh',
                'consumer_key',
                $consumer_key,
                'info'
            );
            $new_input['consumer_key'] = md5($consumer_key);
            $new_input['consumer_key_display'] = 'v4wpwh_ck_...' . substr($consumer_key, -4);
        }else{
            $new_input['consumer_key'] = $v4_wpwh['consumer_key'];
        }
        if (!isset($v4_wpwh['consumer_secret']) || $regen_keys) {
            $consumer_secret = 'v4wpwh_cs_' . str_replace('-', '', wp_generate_uuid4());
            add_settings_error(
                'v4_wpwh',
                'consumer_secret',
                $consumer_secret,
                'info'
            );
            $new_input['consumer_secret'] = md5($consumer_secret);
            $new_input['consumer_secret_display'] = 'v4wpwh_cs_...' . substr($consumer_secret, -4);
        }else{
            $new_input['consumer_secret'] = $v4_wpwh['consumer_secret'];
        }


        //checkboxes
        $new_input['sync_events'] = (isset($input['sync_events']) && $input['sync_events'] == 'on');
        $new_input['sync_event_bookings'] = (isset($input['sync_event_bookings']) && $input['sync_event_bookings'] == 'on');
        $new_input['use_legacy_v3'] = (isset($input['use_legacy_v3']) && $input['use_legacy_v3'] == 'on');
        $new_input['use_wpwh_register_fields'] = (isset($input['use_wpwh_register_fields']) && $input['use_wpwh_register_fields'] == 'on');
        $new_input['show_privacy_if_logged_in'] = (isset($input['show_privacy_if_logged_in']) && $input['show_privacy_if_logged_in'] == 'on');
        $new_input['alt_address'] = (isset($input['alt_address']) && $input['alt_address'] == 'on');
        $new_input['allow_instant_login'] = (isset($input['allow_instant_login']) && $input['allow_instant_login'] == 'on');

		add_settings_error(
			'v4_wpwh',
			'settings_updated',
			__('Settings updated successfully'),
			'success'
		);

        return $new_input;
    }

    /**
     * Print the Section text
     */
    public function print_section_info()
    {
//        print 'Enter your settings below:';
    }

    /**
     * Get the settings option array and print one of its values
     */
    public function callback_1crm_url()
    {
        printf(
            '<input type="text" id="1crm_url" name="v4_wpwh[1crm_url]" value="%s" />',
            isset($this->options['1crm_url']) ? esc_attr($this->options['1crm_url']) : ''
        );
    }

    public function callback_secret()
    {
        printf(
            '<input type="text" id="secret" name="v4_wpwh[secret]" value="%s" />',
            isset($this->options['secret']) ? esc_attr($this->options['secret']) : ''
        );
    }

	public function recaptcha_site_key()
	{
		printf(
			'<input type="text" id="recaptcha_site_key" name="v4_wpwh[recaptcha_site_key]" value="%s" />',
			isset($this->options['recaptcha_site_key']) ? esc_attr($this->options['recaptcha_site_key']) : ''
		);
    }

	public function recaptcha_secret_key()
	{
		printf(
			'<input type="text" id="recaptcha_secret_key" name="v4_wpwh[recaptcha_secret_key]" value="%s" />',
			isset($this->options['recaptcha_secret_key']) ? esc_attr($this->options['recaptcha_secret_key']) : ''
		);
    }

    public function consent_privacy_policy()
    {
        printf(
            '<input type="text" id="consent_privacy_policy" name="v4_wpwh[consent_privacy_policy]" value="%s" />',
            isset($this->options['consent_privacy_policy']) ? esc_attr($this->options['consent_privacy_policy']) : ''
        );
    }

    public function consent_terms_of_participation()
    {
        printf(
            '<input type="text" id="consent_terms_of_participation" name="v4_wpwh[consent_terms_of_participation]" value="%s" />',
            isset($this->options['consent_terms_of_participation']) ? esc_attr($this->options['consent_terms_of_participation']) : ''
        );
    }

    public function callback_consumer_key()
    {
        $settings_errors = get_settings_errors();
        $new_key = false;
		foreach ($settings_errors as $settings_error) {
			if($settings_error['code'] == 'consumer_key'){
				$new_key = $settings_error['message'];
			}
        }
        if ($new_key) {
            ?>
            <p><?= $new_key ?></p>
            <p class="description">Attention: this is only visible once!</p>
            <?php
        } else if(isset($this->options['consumer_key'])){
            if(isset($this->options['consumer_key_display']))
                echo '<p>' . $this->options['consumer_key_display'] . '</p>';
            ?>
            <p class="description">full Consumer Key is hidden.</p>
            <?php
        } else {
            ?>
            <p class="description">save to create a Consumer Key.</p>
            <?php
        }
    }

    public function callback_consumer_secret()
    {
		$settings_errors = get_settings_errors();
		$new_secret = false;
		foreach ($settings_errors as $settings_error) {
			if($settings_error['code'] == 'consumer_secret'){
				$new_secret = $settings_error['message'];
			}
		}
		if ($new_secret) {
			?>
            <p><?= $new_secret ?></p>
            <p class="description">Attention: this is only visible once!</p>
            <?php
        } else if(isset($this->options['consumer_secret'])){
            if(isset($this->options['consumer_secret_display']))
                echo '<p>' . $this->options['consumer_secret_display'] . '</p>';
            ?>
            <p class="description">full Consumer Secret is hidden.</p>
            <?php
        } else {
            ?>
            <p class="description">save to create a Consumer Secret.</p>
            <?php
        }
    }

    public function callback_regen_keys()
    {
        ?>
        <input type="checkbox" id="regen_keys" name="v4_wpwh[regen_keys]"/>
        <?php
    }

    public function callback_user()
    {
        $wpwh_user = (isset($this->options['user'])) ? new WP_User($this->options['user']) : new WP_User();

        $users = get_users([
            'role__in' => ['administrator']
        ]);
        echo "<select id=\"user\" name=\"v4_wpwh[user]\">";
        echo "<option disabled " . ($wpwh_user->ID == 0 ? 'selected' : '') . " >-- choose --</option>";
        foreach ($users as $user) {
            /** WP_User $user */
            $selected = $user->ID == $wpwh_user->ID ? 'selected="selected"' : '';
            echo "<option value='{$user->ID}' $selected>{$user->data->display_name}</option>";
        }
        echo "</select>";
        echo "<p class='description'>user who can create events</p>";
    }

    public function callback_sync_events()
    {
        $checked = isset($this->options['sync_events'])&&$this->options['sync_events'] ? 'checked="checked"' : '';
        ?>
        <input type="checkbox" id="sync_events" name="v4_wpwh[sync_events]" <?= $checked ?> />
        <?php
    }

    public function callback_sync_event_bookings()
    {
        $checked = isset($this->options['sync_event_bookings'])&&$this->options['sync_event_bookings'] ? 'checked="checked"' : '';
        ?>
        <input type="checkbox" id="sync_event_bookings" name="v4_wpwh[sync_event_bookings]" <?= $checked ?> />
        <?php
    }

    public function callback_use_wpwh_register_fields()
    {
        $checked = isset($this->options['use_wpwh_register_fields'])&&$this->options['use_wpwh_register_fields'] ? 'checked="checked"' : '';
        ?>
        <input type="checkbox" id="use_wpwh_register_fields" name="v4_wpwh[use_wpwh_register_fields]" <?= $checked ?> />
        <?php
    }

    public function callback_show_privacy_if_logged_in()
    {
        $checked = isset($this->options['show_privacy_if_logged_in'])&&$this->options['show_privacy_if_logged_in'] ? 'checked="checked"' : '';
        ?>
        <input type="checkbox" id="show_privacy_if_logged_in" name="v4_wpwh[show_privacy_if_logged_in]" <?= $checked ?> />
        <?php
    }

    public function callback_alt_address()
    {
        $checked = isset($this->options['alt_address'])&&$this->options['alt_address'] ? 'checked="checked"' : '';
        ?>
        <input type="checkbox" id="alt_address" name="v4_wpwh[alt_address]" <?= $checked ?> />
        <?php
    }

    public function callback_allow_instant_login()
    {
        $checked = isset($this->options['allow_instant_login'])&&$this->options['allow_instant_login'] ? 'checked="checked"' : '';
        ?>
        <input type="checkbox" id="allow_instant_login" name="v4_wpwh[allow_instant_login]" <?= $checked ?> />
        <?php
    }

    public function callback_default_role()
    {
		$roles = get_editable_roles();
		$fallback_role = 'subscriber';
		$default_role = !empty($this->options['default_role']) ? $this->options['default_role'] : $fallback_role;

		echo "<select id=\"default_role\" name=\"v4_wpwh[default_role]\">";
		echo "<option disabled " . (empty($this->options['default_role']) ? $fallback_role : '') . " >-- choose --</option>";
		foreach ($roles as $key => $role) {
			$selected = $key == $default_role ? 'selected="selected"' : '';
			echo "<option value='{$key}' $selected>{$role['name']}</option>";
		}
		echo "</select>";
    }
}