<?php
/**
 * Created by PhpStorm.
 * User: Anton_Haas
 * Date: 30.05.2018
 * Time: 12:27
 */

class v4Webhook
{

    /**
     * fire webhook
     *
     * @param $json
     * @param $resource
     * @param $event
     * @param $action
     * @throws Exception
     */
    public static function fire_webhook($json, $resource, $event = 'created', $action = "woowh_request", $ignore_rest = false)
    {
		//schleifen vermeiden
		if(defined('REST_REQUEST') && !$ignore_rest)
			return true;

        $wpwh_options = get_option('v4_wpwh');

        if(empty($wpwh_options['1crm_url']))
            return false;

        $url = rtrim($wpwh_options['1crm_url'], "/") . '/json.php?module=v4WebHook&action=' . $action;
        if($_SERVER['SERVER_NAME'] == 'wp.localdev.visual4.de') // for testing
            $url .= '&XDEBUG_SESSION_START=PHPSTORM';

        $secret = $wpwh_options['secret'];
        $hash_raw = hash_hmac('sha256', $json, $secret, true);
        $hash = base64_encode($hash_raw);

        //build header
        $topic = $resource . '.' . $event;
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
        $header = [
            'x-wc-webhook-signature: ' . $hash,
            'x-wc-webhook-topic: ' . $topic,
            'x-wc-webhook-resource: ' . $resource,
            'x-wc-webhook-event: ' . $event,
            'x-wc-webhook-source: ' . home_url('/')
        ];

		$authkey = !strpos($secret, ':') ? $secret . ':x' : $secret;
		$header[] = 'authorization: Basic ' . base64_encode($authkey);


        // setup curl
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1); //disable if asynchronous
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $json);
        curl_setopt($curl, CURLOPT_TIMEOUT, 30);
//        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, (get_option('wpoa_http_util_verify_ssl') == 1 ? 1 : 0));
//        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, (get_option('wpoa_http_util_verify_ssl') == 1 ? 2 : 0));
        $response = curl_exec($curl);
        $error = curl_error($curl);
        $info = curl_getinfo($curl);
        curl_close($curl);

        if (is_string($response))
            $response = trim($response, "\n");

        self::wpwh_log($json, $response, $info['http_code'], $error);
        if ($response && empty($error) && $info['http_code'] == '200') {
//            self::wpwh_log(" - Response: $response \n - Request: $json", false);
            return $response;
        } else {
//            self::wpwh_log(" - Status: {$info['http_code']} \n - Response: $response \n - Request: $json \n - cURL_error: $error");
            $msg = (!empty($response) ? $response : $error);
            throw new \Exception(!empty($msg) ? $msg : ('(' . $info['http_code'] . ')'), $info['http_code']);
        }
    }

    /**
     * @param $request
     * @param $response
     * @param int $http_code
     * @param string $error
     * @var wpdb $wpdb
     */
    public static function wpwh_log($request, $response, $http_code = 200, $error = '')
    {
        //backup old logs
        $files = [
            __DIR__ . '/logs/v4-wp-webhook-error.log',
            __DIR__ . '/logs/v4-wp-webhook.log'
        ];
        foreach ($files as $file)
            if (file_exists($file))
                rename($file, $file . '.' . uniqid());

        global $wpdb;
        $date = date('Y-m-d H:i:s');

        // create table if not exists
        $query = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}wpwh_log (###ID###, datetime datetime, http_code integer, request text, response text, error varchar(255)###AFTER###)";
        $mysql_query = str_replace(['###ID###', '###AFTER###'], ['id int NOT NULL AUTO_INCREMENT', ', PRIMARY KEY (id)'], $query);
        $sql_query = str_replace(['###ID###', '###AFTER###'], ['id int IDENTITY(1,1) PRIMARY KEY', ''], $query);
        $mysql_result = $wpdb->query($mysql_query);
        if ($mysql_result == false)
            $wpdb->query($sql_query);

        // insert
        $data = [
            'datetime' => $date,
            'http_code' => (int)$http_code,
            'request' => $request,
            'response' => $response
        ];
        $format = [
            '%s',
            '%d',
            '%s',
            '%s'
        ];
        if (!empty($error)) {
            $data['error'] = $error;
            $format[] = '%s';
        }
        $wpdb->insert("{$wpdb->prefix}wpwh_log", $data, $format);
    }
}