(function ($) {
    'use strict';

    /**
     * All of the code for your public-facing JavaScript source
     * should reside in this file.
     *
     * Note: It has been assumed you will write jQuery code here, so the
     * $ function reference has been prepared for usage within the scope
     * of this function.
     *
     * This enables you to define handlers, for when the DOM is ready:
     *
     * $(function() {
	 *
	 * });
     *
     * When the window is loaded:
     *
     * $( window ).load(function() {
	 *
	 * });
     *
     * ...and/or other possibilities.
     *
     * Ideally, it is not considered best practise to attach more than a
     * single DOM-ready or window-load handler for a particular page.
     * Although scripts in the WordPress core, Plugins and Themes may be
     * practising this, we should strive to set a better example in our own work.
     */

    $(document).ready(function () {
        //accordion
        $('.wpwh-accordion-content')
            .hide();
        $('.wpwh-accordion-title')
            .css('cursor', 'pointer')
            .click(function () {
                $(this)
                    .siblings('.wpwh-accordion-title')
                    .removeClass('opened')
                    .closest('div')
                    .find('.wpwh-accordion-content')
                    .stop()
                    .slideUp();
                $(this)
                    .toggleClass('opened')
                    .closest('div')
                    .find('.wpwh-accordion-content')
                    .stop()
                    .slideToggle();
                if ($(this).hasClass('wpwh-accordion-title-disappear'))
                    $(this).stop().slideUp();
            });

        $('#em-booking-form, .em-booking-form').each(function () {
            $(this).find('.form_toggle').each(function () {
                var $form_toggle_wrapper = $(this).closest('.form_toggle_wrapper'),
                    is_inverted = $form_toggle_wrapper.hasClass('inverted');
                if (xor($(this).is(':checked'), is_inverted))
                    $form_toggle_wrapper.addClass('opened');
                else
                    $form_toggle_wrapper.removeClass('opened');
            });
            $(this).on('click', '.form_toggle', function () {
                $(this).closest('.form_toggle_wrapper').toggleClass('opened');
            });
        });

        $('.wpwh-form').submit(function (e) {
            e.preventDefault();
            $(this).find('.wpwh-error').remove();
            var $loading = $('<div id="loading-wrapper" style="display: none;"><div id="loading" class="sk-cube-grid">' +
                '<div class="sk-cube sk-cube1"></div>' +
                '<div class="sk-cube sk-cube2"></div>' +
                '<div class="sk-cube sk-cube3"></div>' +
                '<div class="sk-cube sk-cube4"></div>' +
                '<div class="sk-cube sk-cube5"></div>' +
                '<div class="sk-cube sk-cube6"></div>' +
                '<div class="sk-cube sk-cube7"></div>' +
                '<div class="sk-cube sk-cube8"></div>' +
                '<div class="sk-cube sk-cube9"></div>' +
                '</div></div>');
            $(this).append($loading);
            $loading.fadeIn();
            (function ($form) {
                $.ajax({
                    type: "POST",
                    url: $form.attr('action'),
                    data: $form.serialize(),
                    success: function (data) {
                        let parsedData;
                        try {
                            parsedData = JSON.parse(data);
                        } catch (e){
                            parsedData = {
                                status: 500,
                                msg: 'internal server error'
                            };
                        }
                        if (parsedData.status === 200) {
                            let success_msg = $('<span class="wpwh-success success success--main">' + parsedData.msg + '</span>');
                            let wpwh_form = $('.wpwh-form');
                            if(wpwh_form.attr('id') === 'wpwh-registerform')
                                wpwh_form.slideUp();
                            wpwh_form.before(success_msg);
                            if(typeof parsedData.reload !== 'undefined' && parsedData.reload === true)
                                location.reload();
                            else{
                                //fix display
                                $('.wpwh-form > div input').each(function(){
                                    let val = $(this).val();
                                    $(this).siblings('p').html(val);
                                });
                                $('.wpwh-form > div select').each(function(){
                                    let val_arr = [];
                                    let val = '';
                                    $(this).find('option:selected').each(function(){
                                        val_arr.push($(this).text());
                                    });
                                    val = val_arr.join(', ');
                                    $(this).siblings('p').html(val);
                                });
                                $('.wpwh-my-account-view-toggle--cancel').first().trigger('click');
                            }
                        } else {
                            let error_msg = $('<span class="wpwh-error error error--main">' + parsedData.msg + '</span>');
                            $form.prepend(error_msg);

                            if (typeof grecaptcha !== 'undefined')
                                grecaptcha.reset();

                            $.each(parsedData.errors, function (k, v) {
                                error_msg = $('<span class="wpwh-error error">' + v + '</span>');
                                $('label[for="wpwh-registerform-' + k + '"], label[for="wpwh-my-account-form-' + k + '"]').parent().append(error_msg);
                            });
                        }
                        $(document).scrollTop($form.offset().top - 50);
                    },
                    complete: function (data) {
                        let parsedData;
                        try {
                            parsedData = JSON.parse(data.responseText);
                        } catch (e){
                            parsedData = {
                                status: 500,
                                msg: 'internal server error'
                            };
                        }
                        if(typeof parsedData.reload === 'undefined' || parsedData.reload !== true)
                            $('#loading-wrapper').fadeOut(function () {
                                $(this).remove();
                            });
                    }
                });
            })($(this));
        });

        //my-account view
        $('.wpwh-my-account-view-toggle').on('click', function(e){
            e.preventDefault();
            $(this)
                //.hide()
                .closest('.wpwh-form')
                .toggleClass('edit');
        });

        //wc captcha validation
        $(document.body).on('checkout_error', function(e){
            if (typeof grecaptcha !== 'undefined')
                grecaptcha.reset();
        });
    });

})(jQuery);

if (typeof xor !== "function") {
    function xor(a, b) {
        return (a || b) && !(a && b);
    }
}
