<?php
/**
 * Created by PhpStorm.
 * User: Anton_Haas
 * Date: 02.06.2017
 * Time: 15:01
 */

$fields = [
    'name' => [
        'name' => 'Name',
        'slug' => 'billing_address_name',
        'type' => 'text',
        'required' => true
    ],
    'street' => [
        'name' => 'Straße und Hausnummer',
        'slug' => 'billing_address_street',
        'type' => 'text',
        'required' => true
    ],
    'postalcode' => [
        'name' => 'Postleitzahl',
        'slug' => 'billing_address_postalcode',
        'type' => 'text',
        'required' => true
    ],
    'city' => [
        'name' => 'Ort',
        'slug' => 'billing_address_city',
        'type' => 'text',
        'required' => true
    ],
//    'state' => [
//        'name' => 'Bundesland',
//        'slug' => 'billing_address_state',
//        'type' => 'text',
//        'required' => true
//    ],
    'country' => [
        'name' => 'Land',
        'slug' => 'billing_address_country',
        'type' => 'country',
        'required' => true
    ],
    'phone' => [
        'name' => 'Telefonnummer',
        'slug' => 'billing_phone',
        'type' => 'text'
    ]
];

//TODO admin option
?>
    <div class="billing_address_wrapper">
        <h3>Adresse</h3>
        <?php
		if (function_exists('WC') && WC()->customer !== null) {
            $address = [
                $fields['name']['name'] => WC()->customer->get_display_name(),
                $fields['street']['name'] => WC()->customer->get_address(),
                $fields['postalcode']['name'] => WC()->customer->get_postcode(),
                $fields['city']['name'] => WC()->customer->get_city(),
//                $fields['state']['name'] => WC()->customer->get_state(),
                $fields['country']['name'] => WC()->countries->get_countries()[WC()->customer->get_country()],
                $fields['phone']['name'] => WC()->customer->get_billing_phone(),
            ];
        } else if (isset($EM_Obj)) {
            /** @var EM_Event|EM_Multiple_Booking $EM_Obj */
            $EM_Person = $EM_Obj->get_contact();
            $address = [
                $fields['name']['name'] => $EM_Person->display_name
                //em form
            ];
        }
        foreach ($address as $k => $v) {
            if (empty($v))
                $v = "&nbsp;";
            ?>
            <p>
                <label><?= $k ?></label>
                <span><?= $v ?></span>
            </p>
            <?php
        }
        ?>
    </div>
    <div class="billing_address_alternate_wrapper">
        <h3 class="form_toggle_wrapper">
            <?php
            $lbl_billing_address_alternate = __('Use a different billing address?', 'v4-wp-webhook');
            ?>
            <label for="billing_address_alternate"><?= $lbl_billing_address_alternate ?> <input class="form_toggle"
                                                                                                type="checkbox"
                                                                                                name="billing_address_alternate"
                                                                                                id="billing_address_alternate"/></label>
        </h3>
        <div class="billing_address_alternate_fields">
            <?php
            $alternate_fields = apply_filters('v4-wp-webhook/public/checkout-alternate-address-fields', $fields);
            foreach ($alternate_fields as $k => $field) {
                $is_required = isset($field['required']) && (bool)$field['required'];

                ?>
                <p class="input-group input-field-<?= $field['slug'] ?>">
                    <label for="<?= $field['slug'] ?>"><?= $field['name'] ?><?php if ($is_required) echo '<span class="em-form-required">*</span>'; ?></label>
                    <?php
                    switch ($field['type']) {
                        case 'textarea':
                            ?>
                            <textarea class="input"
                                      name="<?php echo 'wpwh[checkout][' . $field['slug'] . ']' ?>"
                                      id="<?= $field['slug'] ?>"></textarea>
                            <?php
                            break;
                        case 'country':
                            global $woocommerce;
                            $countries_obj = new WC_Countries();
                            $countries = $countries_obj->__get('countries');
                            ?>
                            <select name="<?php echo 'wpwh[checkout][' . $field['slug'] . ']' ?>"
                                    id="<?= $field['slug'] ?>">
                                <option disabled>-- bitte wählen --</option>
                                <?php
                                foreach ($countries as $code => $country) {
                                    ?>
                                    <option <?php if ($code == 'DE') echo 'selected="selected"'; ?>
                                            value="<?= $code ?>"><?= $country ?></option>
                                    <?php
                                }
                                ?>
                            </select>
                            <?php
                            break;
                        default:
                            ?>
                            <input class="input"
                                   type="<?= $field['type'] ?>"
                                   name="<?php echo 'wpwh[checkout][' . $field['slug'] . ']' ?>"
                                   id="<?= $field['slug'] ?>"/>
                            <?php
                            break;
                    }
                    if ($is_required) echo '<input type="hidden" name="wpwh[checkout-required][' . $field['slug'] . ']" value="' . $field['name'] . '">'; ?>
                </p>
                <?php
            }
            ?>
        </div>
    </div>
    <h3>Zusätzliche Informationen</h3>
<?php
