<?php
/**
 * @var array $args
 */

use v4\wp\plugins\oauth\Settings;

?>
<div class="wpwh-container wpwh-container-loginRegister">
	<?php
    $signInPhrase = apply_filters( 'v4-wp-webhook/signInPhrase', __('Sign in here:', 'v4-wp-webhook') );
    $registerPhrase = apply_filters('v4-wp-webhook/registerPhrase', __('or create a new account here:', 'v4-wp-webhook'));
    $showLoginButton = apply_filters('v4-wp-webhook/showLoginButton', true);

	if (is_user_logged_in()) {
		?>
        <p><?= __("You are already logged in.", "v4-wp-webhook") ?></p>
		<?php
	} else {
        $redirect_to = !empty($args['redirect_to']) ? '&redirect_to=' . urlencode($args['redirect_to']) : '';
		?>
        <div class="wpwh-login">
            <p class="wpwh-login_signInPhrase"><b><?= $signInPhrase ?></b></p>
            <?php if($showLoginButton){?>
                <p class="wpwh-login_signInButton"><a class="button <?= $args['button-class'] ?? '' ?>"
               href="<?php echo '?connect=1crm' . $redirect_to; ?>"><?php _e('Login', 'woocommerce'); ?></a></p>
            <?php } ?>
            
            <?php
            $v4_oauth_options = get_option('v4_oauth');
            if (!empty($v4_oauth_options['providers'])) {
                foreach ($v4_oauth_options['providers'] as $provider) {
                    ?>
                    <p><a class="oauth-provider oauth-provider--<?= $provider ?>"
                       href="?connect=<?= $provider . $redirect_to ?>">Sign in with <?= Settings::$providers[$provider] ?></a></p>
                    <?php
                }
            }
            ?>
        </div>
		<?php
		if (isset($args['register']) && $args['register']) {
			?>
            <div class="wpwh-register">
                <p><b><?= $registerPhrase ?></b></p>
				<?php
				$shortcode = '[wpwh_register' .
					' button-class="' . ($args['button-class'] ?? '') . '"' .
					' redirect_to="' . ($args['redirect_to'] ?? '') . '"' .
					' instant_login="' . ($args['register_instant_login'] ?? '0') . '"' .
					' accordion="'.($args['accordion'] ?? apply_filters( 'v4-wp-webhook/activateRegisterAccordion', __('Register', 'v4-wp-webhook') )).'"]';
				echo do_shortcode($shortcode);
				?>
            </div>
			<?php
		}
	}
	?>
</div>