<?php
/**
 * @var array $args
 */

$wpwh_options = get_option('v4_wpwh');

?>
    <div class="wpwh-container">
		<?php
		if (is_user_logged_in()) {

			if (!empty($user) && $user['status'] == 'failure') {
				?>
                <p><?= __("Please check your input and try again.", "v4-wp-webhook") ?></p>
				<?php
			} else if (!empty($user) && $user['status'] == 'success') {
				?>
                <p><?= __("Success! Your personal data has been changed.", "v4-wp-webhook") ?></p>
				<?php
			}
			?>
            <form id="wpwh-my-account-form" class="wpwh-form wpwh-form--account" name="my-account-form"
                  action="<?php echo admin_url('admin-post.php') ?>"
                  method="post">
				<?php
				/** @var V4_Wp_Webhook_Admin $V4_Wp_Webhook_Admin */
				global $V4_Wp_Webhook_Admin;
				foreach ($V4_Wp_Webhook_Admin->get_my_account_fields() as $key => $field) {
					?>
                    <div <?php if(!empty($field['classes'])) echo 'class="' . implode(' ', $field['classes']) . '"'; ?>>
                        <label for="wpwh-my-account-form-<?= $key ?>">
							<strong>
								<?= __($field['name'], "v4-wp-webhook") ?>:
								<?php if (!empty($field['required']) && $field['required'] && (!isset($field['editable']) || $field['editable'])) echo '<abbr class="required" title="erforderlich">*</abbr>'; ?>
							</strong>
						</label>
						<?php

						//get value
						switch ($key) {
							case 'email':
								$current_user = wp_get_current_user();
								$value = $current_user->data->user_email;
								break;
							default:
								$value = get_user_meta(get_current_user_id(), $key, true);
								$value = maybe_unserialize($value);
								break;
						}

						if (isset($field['editable']) && $field['editable'] === false)
							if ($field['type'] == 'select')
								echo "<p>" . ($field['options'][$value] ?? '-') . "&nbsp;</p>";
							else
								echo "<p>" . (!empty($value) ? $value : '-') . "&nbsp;</p>";
						else {
							switch ($field['type']) {
								case 'text':
									echo "<p class='wpwh-my-account-view'>" . $value . "&nbsp;</p>";
									?>
                                    <input type="text" name="<?= $key ?>" id="wpwh-my-account-form-<?= $key ?>"
                                           class='wpwh-my-account-edit'
                                           value="<?php if (!empty($value)) echo $value; ?>">
									<?php
									break;
								case 'select':
									$is_multiple = isset($field['multiple']) && $field['multiple'] == true;

									$html = '';
									if ($is_multiple) {
										if (is_array($value))
											foreach ($value as $item)
												$html .= ', ' . $field['options'][$item];
										else
											$html = $value;
									} else
										foreach ($field['options'] as $option_key => $option) {
											if (is_array($option)) {
												foreach ($option as $sub_option_key => $sub_option) {
													if ($sub_option_key == $value) {
														$html = $sub_option;
													}
												}
											} else {
												if ($option_key == $value) {
													$html = $field['options'][$value];
												}
											}
										}
									$html = trim($html, ', ');

									echo "<p class='wpwh-my-account-view'>$html&nbsp;</p>";


									?>
                                    <select name="<?= $key ?><?php if ($is_multiple) echo '[]' ?>"
                                            id="wpwh-my-account-form-<?= $key ?>"
                                            class='wpwh-my-account-edit'
										<?php if ($is_multiple) echo 'multiple' ?>
                                            class="wpwh-my-account-form-field wpwh-my-account-form_field--select">
										<?php
										if (empty($value))
											echo "<option disabled selected value> -- " . __("select an option", "v4-wp-webhook") . " -- </option>";
										foreach ($field['options'] as $option_key => $option) {
											if(is_array($option)){
												?>
												<optgroup label="<?= $option_key ?>">
													<?php
													foreach ($option as $sub_option_key => $sub_option){
														if ($is_multiple)
															$selected = in_array($sub_option_key, $value);
														else
															$selected = !empty($value) && $value == $sub_option_key;
														?>
														<option value="<?= $sub_option_key ?>" <?php if ($selected) echo 'selected="selected"'; ?>><?= $sub_option ?></option>
														<?php
													}
													?>
												</optgroup>
												<?php
											} else {
												if ($is_multiple && is_array($value))
													$selected = in_array($option_key, $value);
												else
													$selected = !empty($value) && $value == $option_key;
												?>
												<option value="<?= $option_key ?>" <?php if ($selected) echo 'selected="selected"'; ?>><?= $option ?></option>
												<?php
											}
										}
										?>
                                    </select>
									<?php
									break;
								case 'email':
									echo "<p class='wpwh-my-account-view'>" . (is_array($value) ? implode(', ', $value) : $value) . "&nbsp;</p>";
									?>
                                    <input type="email" name="<?= $key ?>" id="wpwh-my-account-form-<?= $key ?>"
                                           class='wpwh-my-account-edit'
                                           value="<?php if (!empty($value)) echo $value; ?>">
									<?php
									break;
								case 'date':
									echo "<p class='wpwh-my-account-view'>" . (!empty($value) ? date('d.m.Y', strtotime($value)) : '') . "&nbsp;</p>";
									?>
                                    <input type="date" name="<?= $key ?>" id="wpwh-my-account-form-<?= $key ?>"
                                           class='wpwh-my-account-edit'
                                           value="<?php if (!empty($value)) echo $value; ?>">
									<?php
									break;
								case 'html':
								    //deprecated
									echo(is_array($field['value']) ? implode(', ', $field['value']) : $field['value']);
									//use action instead
									do_action('v4wpwh_register_field_html_' . $key, $field, $user[$key]??null);
									break;
								case 'custom':
									do_action('v4wpwh_register_field_html_' . $key, $field, $user[$key]??null);
									break;
								default:
									echo "<p class='error'>unsupported type: '{$field['type']}' for field: '$key'</p>";
									break;
							}
						}
						?>
                    </div>
					<?php
				}
				?>

                <input type="hidden" name="action" value="wpwh_my_account"/>

                <p class="submit">
                    <a type="button"
                       class="button <?= $args['button-class'] ?? '' ?> wpwh-my-account-view-toggle"><?= __('Edit', 'v4-wp-webhook') ?></a>
                    <input type="submit" id="wp-submit"
                           class="<?php if (!empty($args['button-class'])) echo $args['button-class']; ?> wpwh-my-account-edit"
                           value="<?= __('Submit changes', 'v4-wp-webhook') ?>"/>
                    <a type="button"
                       class="button <?= $args['button-class'] ?? '' ?> wpwh-my-account-view-toggle wpwh-my-account-view-toggle--cancel"><?= __('Cancel', 'v4-wp-webhook') ?></a>
                </p>
            </form>
            <a class="button <?= $args['button-class'] ?? '' ?>"
               href="?change_password<?php echo "&redirect_uri=" . get_permalink(); ?>"><?php _e('Change password', 'v4-wp1crm-extensions') ?></a>
            <a class="button <?= $args['button-class'] ?? '' ?>"
               href="<?php echo wp_logout_url(); ?>"><?= __('Logout', 'v4-wp-webhook') ?></a>
			<?php
		} else {
			$shortcode = '[wpwh_login' .
				' register="' . ($args['register'] ?? '0') . '"' .
				' button-class="' . ($args['button-class'] ?? '') . '"' .
				' redirect_to="' . ($args['redirect_to'] ?? '') . '"' .
				' register_instant_login="' . ($args['register_instant_login'] ?? '0') . '"' .
				' accordion="' . ($args['accordion'] ?? apply_filters( 'v4-wp-webhook/activateRegisterAccordion', __('Register', 'v4-wp-webhook') )) . '"]';
			echo do_shortcode($shortcode);
		}
		?>
    </div>