<?php
/**
 * @var array $args
 */

$wpwh_options = get_option('v4_wpwh');
$containerClasses = apply_filters('v4-wp-webhook/registerContainerClasses', "wpwh-accordion-content");
$registerFormButtonClasses = apply_filters('v4-wp-webhook/registerFormButtonClasses', "");


if (defined('ICL_LANGUAGE_CODE'))
	echo '<input type="hidden" name="lang" value="' . ICL_LANGUAGE_CODE . '">';

/** @var V4_Wp_Webhook_Admin $V4_Wp_Webhook_Admin */
global $V4_Wp_Webhook_Admin;
foreach ($V4_Wp_Webhook_Admin->get_register_fields() as $key => $field) {
	?>
	<div class="wpwh-registerform-field-container <?php if (!empty($field['classes'])) { echo implode(' ', $field['classes']); } ?>">
		<label for="wpwh-registerform-<?= $key ?>">
			<?= __($field['name'], "v4-wp-webhook") ?>
			<?php if (!empty($field['required'])) echo '<abbr class="required" title="erforderlich">*</abbr>'; ?>
		</label>
		<?php
		switch ($field['type']) {
			case 'text':
				?>
				<input type="text" name="<?= $key ?>" id="wpwh-registerform-<?= $key ?>"
					   value="<?php if (!empty($user[$key])) echo $user[$key]; ?>"
                    <?php if($field['validation_type'] === 'honeypot') echo 'tabindex="-1"'; ?>>
				<?php
				break;
			case 'select':
				$is_multiple = isset($field['multiple']) && $field['multiple'] == true;
				if (empty($user[$key]) && !empty($field['default']))
					$user[$key] = $field['default'];
				?>
				<select name="<?= $key ?><?php if ($is_multiple) echo '[]' ?>" id="wpwh-registerform-<?= $key ?>"
					<?php if ($is_multiple) echo 'multiple' ?>
						class="wpwh-registerform-field wpwh-registerform_field--select">
					<?php
					echo "<option value> -- " . __("select an option", "v4-wp-webhook") . " -- </option>";
					foreach ($field['options'] as $option_key => $option) {
						if(is_array($option)){
							?>
							<optgroup label="<?= $option_key ?>">
								<?php
								foreach ($option as $sub_option_key => $sub_option){
									$selected = false;
									if(isset($user[$key]))
									if ($is_multiple)
										$selected = in_array($sub_option_key, $user[$key]);
									else
										$selected = !empty($user[$key]) && $user[$key] == $sub_option_key;
									?>
									<option value="<?= $sub_option_key ?>" <?php if ($selected) echo 'selected="selected"'; ?>><?= $sub_option ?></option>
									<?php
								}
								?>
							</optgroup>
							<?php
						} else {

							$selected = false;
							if(isset($user[$key]))
								if ($is_multiple)
									$selected = in_array($option_key, $user[$key]);
								else
									$selected = !empty($user[$key]) && $user[$key] == $option_key;
							?>
							<option value="<?= $option_key ?>" <?php if ($selected) echo 'selected="selected"'; ?>><?= $option ?></option>
							<?php
						}
					}
					?>
				</select>
				<?php
				break;
			case 'email':
				?>
				<input type="email" name="<?= $key ?>" id="wpwh-registerform-<?= $key ?>"
					   value="<?php if (!empty($user[$key])) echo $user[$key]; ?>">
				<?php
				break;
			case 'date':
				?>
				<input type="date" name="<?= $key ?>" id="wpwh-registerform-<?= $key ?>"
					   value="<?php if (!empty($user[$key])) echo date('d.m.Y', strtotime($user[$key])); ?>">
				<?php
				break;
			case 'custom':
				do_action('v4wpwh_register_field_html_' . $key, $field, $user[$key] ?? null);
				break;
			default:
				echo "<p class='error'>unsupported type: '{$field['type']}' for field: '$key'</p>";
				break;
		}
		?>
	</div>
	<?php
}