<?php
/**
 * @var array $args
 */

$wpwh_options = get_option('v4_wpwh');
$containerClasses = apply_filters( 'v4-wp-webhook/registerContainerClasses', "wpwh-accordion-content" );
$registerFormButtonClasses = apply_filters( 'v4-wp-webhook/registerFormButtonClasses', "" );

if (isset($args) && !empty($args['accordion'])) {
    ?>
    <p><a class="wpwh-accordion-title button <?= $args['button-class'] ?? '' ?>"><?= $args['accordion'] ?></a></p>
    <div class="<?= $containerClasses ?>">
    <?php
}

?>
    <div class="wpwh-container">
        <?php
        if (is_user_logged_in()) {
            ?>
            <p class="wpwh-error error error--main"><?= __("You are already logged in.", "v4-wp-webhook") ?></p>
            <?php
        } else if (!empty($user) && $user['status'] == 'success') {
            ?>
            <p class="wpwh-error error error--main"><?= __("Success! You will receive an e-mail with your login information soon.", "v4-wp-webhook") ?></p>
            <a href="<?php echo rtrim(get_home_url(), '/') . '/?connect=1crm'; if(!empty($args['redirect_to'])) echo '&redirect_to='.urlencode($args['redirect_to']); ?>">Login</a>
            <?php
        } else {
            if (!empty($user) && $user['status'] == 'failure') {
                ?>
                <p class="wpwh-error error error--main"><?= __("Please check your input and try again.", "v4-wp-webhook") ?></p>
                <?php
            }
            ?>
            <form id="wpwh-registerform" class="wpwh-form" name="registerform" action="<?php echo admin_url('admin-post.php') ?>"
                  method="post">
                <?php

				if(!empty($args['instant_login']) && $args['instant_login'])
					echo '<input type="hidden" name="instant_login" value="1">';

				include __DIR__ . '/v4-wp-webhook-public-register-fields.php';

				include __DIR__ . '/v4-wp-webhook-public-consent-fields.php';

                ?>

                <input type="hidden" name="action" value="wpwh_register"/>

                <p class="submit">
                    <input type="submit" id="wp-submit"
                           class="button <?= $args['button-class'] ?? '' ?> <?= $registerFormButtonClasses ?>"
                           value="<?= __('Submit registration', 'v4-wp-webhook') ?>"/>
                </p>
            </form>
            <?php
        }
        ?>
    </div>
<?php

if (isset($args) && !empty($args['accordion'])) {
    ?>
    </div>
    <?php
}
