<?php

if (!session_id()) {
	session_start();
}

require_once(__DIR__ . "/../../../../wp-load.php");
require_once(__DIR__ . "/../admin/rest_api/emp/v1/WPWH_REST_EMP_Event.php");
require_once(__DIR__ . "/../admin/rest_api/auth/WPWH_REST_Authentication.php");


use PHPUnit\Framework\TestCase;
use v4\wp\plugins\wp1crm\Customer;

class WPWH_CustomerTest extends TestCase
{
	public function test_compareEventAndWooCustomer()
	{
		try {
			$EM_Person = new EM_Person(1);
			$v4Customer_em = new Customer($EM_Person);
			$v4Customer_em_data = $v4Customer_em->get_data();
			v4_recur_ksort($v4Customer_em_data);

			$WC_Customer = new WC_Customer(1);
			$v4Customer_wc = new Customer($WC_Customer);
			$v4Customer_wc_data = $v4Customer_wc->get_data();
			v4_recur_ksort($v4Customer_wc_data);

			$this->assertEquals(print_r($v4Customer_em_data, true), print_r($v4Customer_wc_data, true), 'em customer != wc customer');
		} catch (Exception $e) {
			$this->fail('customer error: ' . $e->getMessage());
		}

	}
}
