<?php

if (!session_id()) {
	session_start();
}

require_once(__DIR__ . "/../../../../wp-load.php");
require_once(__DIR__ . "/../admin/rest_api/emp/v1/WPWH_REST_EMP_Event.php");
require_once(__DIR__ . "/../admin/rest_api/auth/WPWH_REST_Authentication.php");


use PHPUnit\Framework\TestCase;

class WPWH_REST_EMP_EventTest extends TestCase
{
	public static function setUpBeforeClass(): void
	{
		$wpwh = get_option('v4_wpwh');
		wp_set_current_user($wpwh['user']);
	}

	public static function tearDownAfterClass(): void
	{
		session_destroy();
	}

    public function test_newEvent()
    {
        $WPWH_REST_EMP_Event = new WPWH_REST_EMP_Event();
        $request = new WP_REST_Request();

        $data = [
            'name' => 'Test',
            'status' => 'draft',
            'spaces' => 20,
            'start_date' => '2021-10-01 11:12:13',
            'end_date' => '2021-10-05 12:13:14',
            'rsvp_date' => '2021-10-02 05:06:07',
            'description' => 'Description!',
        ];
        $request->set_body(json_encode($data));

        $result = $WPWH_REST_EMP_Event->create_update_item($request);

        $this->assertEquals('WP_REST_Response', get_class($result));
        $this->assertTrue(is_numeric($result->data['id']), 'Event ID missing. Maybe couldn\'t be created.');

//        // delete created Event
//        $EM_Event = new EM_Event($result->data['id']);
//        $EM_Event->delete(1);
    }
}
