<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              http://www.visual4.de/
 * @package           V4_Wp_Webhook
 *
 * @wordpress-plugin
 * Plugin Name:       v4 WP WebHook
 * Plugin URI:        http://www.visual4.de/
 * Description:       Webhooks, The EventsManager Pro, 1CRM
 * Version:           2.6.9
 * Requires:          5.8
 * Requires PHP:      7.4
 * Author:            visual4
 * Author URI:        http://www.visual4.de/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       v4-wp-webhook
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-v4-wp-webhook-activator.php
 */
function activate_v4_wp_webhook() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-v4-wp-webhook-activator.php';
	V4_Wp_Webhook_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-v4-wp-webhook-deactivator.php
 */
function deactivate_v4_wp_webhook() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-v4-wp-webhook-deactivator.php';
	V4_Wp_Webhook_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_v4_wp_webhook' );
register_deactivation_hook( __FILE__, 'deactivate_v4_wp_webhook' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-v4-wp-webhook.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_v4_wp_webhook() {

	$plugin = new V4_Wp_Webhook();
	$plugin->run();

}
run_v4_wp_webhook();
